package JavaGroups.JavaStack;



/**
 * This interface supports methods to handle low-level address stuff specific to
 * different communication protocols. For example, ATM addresses are different from Internet
 * addresses. A class implementing LowLevelCommunication needs to be able to create local
 * addresses (endpoints for unicast communication), find and reserve available multicast
 * addresses (assuming the multicast is available on all systems), and join and leave them.<p>
 * <b>The bottommost protocol layer in a protocol stack *has* to implement this interface</b>
 */
public interface LowLevelCommunication {

    /**
     * Create a new unicast endpoint, e.g. in the case of the Internet protocol an
     * address consisting of an IP address and a port.
     */
    public Address GetLocalAddress();

    /**
     * Chooses a multicast address that is not yet used by other entities. Consists of
     * IP address and port.
     */
    public Address GetNewMulticastAddress();

    /**
     * Joins a multicast address.
     * @param mcast_address Multicast address previously received by GetNewMulticastAddress
     */
    public void JoinMulticastAddress(Address mcast_address);

    /**
     * @param mcast_address Multicast address previously received by GetNewMulticastAddress
     */
    public void LeaveMulticastAddress(Address mcast_address);

}
