package JavaGroups.JavaStack;


import java.io.*;
import java.net.*;
import java.util.*;


public class GossipClient implements Runnable {
    private Thread               updater=null;
    private Address              my_addr=null;
    private String               host=null;
    private int                  port=12001;
    private String               groupname=null;
    private final long           TIMEOUT=6000;
    private Socket               sock=null;
    private OutputStream         o;
    private ObjectOutputStream   out;
    private ObjectInputStream    inp;
    private Request              req;



    private void CloseSocket() {
	try {
	    if(o != null)
		o.flush();
	    if(sock != null)
		sock.close();
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }



    public GossipClient(String groupname, String host, int port) {
	this.groupname=groupname;
	this.host=host;
	this.port=port;	
	if(this.host == null) {
	    try {
		this.host=InetAddress.getLocalHost().getHostName();
	    }
	    catch(Exception e) {
		System.err.println(e);
		this.host=null;
	    }
	}	
    }



    public synchronized void Register(Address addr) {
	my_addr=addr;
	try {
	    sock=new Socket(host, port);
	    o=sock.getOutputStream();
	    out=new ObjectOutputStream(o);
	    req=new Request(Request.REGISTER, groupname, my_addr);
	    out.writeObject(req);
	    o.flush();
	    Thread.currentThread().sleep(1500);
	}
	catch(Exception ex) {
	    System.err.println("GossipClient.Register(): " + ex);
	}
	finally {
	    CloseSocket();
	}
    }



    public synchronized Vector Get(String groupname) {
	Vector retval=new Vector();

	try {
	    sock=new Socket(host, port);
	    o=sock.getOutputStream();
	    out=new ObjectOutputStream(o);
	    req=new Request(Request.GET, groupname, null);
	    out.writeObject(req);
	    o.flush();
	    inp=new ObjectInputStream(sock.getInputStream());
	    retval=(Vector)inp.readObject();
	    return retval;
	}
	catch(Exception e) {
	    System.err.println("GossipClient.Get(): " + e);
	    return retval;
	}
	finally {
	    CloseSocket();
	}
    }



    public void Start() {
	if(updater == null) {
	    updater=new Thread(this);
	    updater.start();
	}
    }



    public void Stop() {
	if(updater != null) {
	    updater.stop();
	    updater=null;
	}
    }



    
    public void run() {
	while(true) {	   
	    try {
		Thread.currentThread().sleep(TIMEOUT);

		if(my_addr == null)
		    continue;

		Register(my_addr);
	    }
	    catch(Exception ex) {
		System.err.println("GossipClient.SetAddress(): " + ex);
	    }
	}
	
    }






    public static void main(String args[]) {
	String         host=null;
	int            port=12001;
	String         arg, next_arg;
	GossipClient   client=null;


	for(int i=0; i < args.length; i++) {
	    arg=args[i];
	    if(arg.equals("-help")) {
		System.out.println("GossipClient [-host <hostname>] [-port <registry port> ]");
		return;
	    }
	    else if(arg.equals("-port")) {
		port=new Integer(args[++i]).intValue();
		continue;
	    }
	    else if(arg.equals("-host")) {
		host=args[++i];
		continue;
	    }
	}

	try {
	    Address my_addr=new Address(InetAddress.getByName(host), port);
	    client=new GossipClient("DemoGroup", host, port);
	    client.Register(my_addr);
	    client.Start();	
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }
}


