package JavaGroups.JavaStack;



/**
 * Used for inter-stack and intra-stack communication.
 */
public class Event implements java.io.Serializable {
    public static final int MSG                       =  1;
    public static final int JOIN                      =  2;
    public static final int LEAVE                     =  3;
    public static final int LEAVE_OK                  =  4;
    public static final int VIEW_CHANGE               =  5;
    public static final int GET_LOCAL_ADDRESS         =  6;
    public static final int SET_LOCAL_ADDRESS         =  7;
    public static final int FLUSH                     =  8;
    public static final int FLUSH_OK                  =  9;
    public static final int SUSPECT                   = 10;


    private int     type=0;       // type of event
    private Object  arg=null;     // must be serializable if used for inter-stack communication


    public Event(int type) {
	this.type=type;
    }

    public Event(int type, Object arg) {
	this.type=type;
	this.arg=arg;
    }

    public int     GetType()                {return type;}
    public void    SetType(int type)        {this.type=type;}

    public Object  GetArg()                 {return arg;}
    public void    SetArg(Object arg)       {this.arg=arg;}



    String Type2String(int t) {
	switch(t) {
	case MSG:
	    return "MSG";
	case JOIN:
	    return "JOIN";
	case LEAVE:
	    return "LEAVE";
	case LEAVE_OK:
	    return "LEAVE_OK";
	case VIEW_CHANGE:
	    return "VIEW_CHANGE";
	case GET_LOCAL_ADDRESS:
	    return "GET_LOCAL_ADDRESS";
	case SET_LOCAL_ADDRESS:
	    return "SET_LOCAL_ADDRESS";
	case FLUSH:
	    return "FLUSH";
	case FLUSH_OK:
	    return "FLUSH_OK";
	case SUSPECT:
	    return "SUSPECT";
	default:
	    return "UNDEFINED";
	}
    }

    public String toString() {
	StringBuffer ret=new StringBuffer();
	ret.append("Event[type=" + type + " ("+Type2String(type)+"), arg=" + arg + "]");
	return ret.toString();
    }
}

