package JavaGroups;

import java.io.*;

/** 
 * Container for header data which is added to the front of a Message by a protocol layer
 * when traveling down the stack. When traveling up on the other side, each protocol layer
 * will remove its Header.
 */

public class Header implements Serializable, Cloneable {
    private byte    data[]=null;
    

    public          Header()         {}
    public          Header(byte d[]) {data=d;}


    public          Header(Serializable msg) {	
	ByteArrayOutputStream out_stream=new ByteArrayOutputStream();
	ObjectOutputStream    out;
	
	try {
	    out=new ObjectOutputStream(out_stream);
	    out.writeObject(msg);
	    data=out_stream.toByteArray();
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }


    public byte[]   GetData()                  {return data;}
    public void     SetData(byte new_data[])   {data=new_data;}
    public long     Size()                     {return data == null ? 0 : data.length;}



    public void SetObject(Serializable obj) {
	ByteArrayOutputStream out_stream=new ByteArrayOutputStream();
	ObjectOutputStream    out;
	
	try {
	    out=new ObjectOutputStream(out_stream);
	    out.writeObject(obj);
	    data=out_stream.toByteArray();
	}
	catch(Exception e) {
	    System.err.println(e);
	}	
    }




    public Object GetObject() {
	if(data == null || data.length < 1)
	    return null;
	Object                ret=null;
	ByteArrayInputStream  inp_stream=new ByteArrayInputStream(data);
	ObjectInputStream     inp=null;

	try {
	    inp=new ObjectInputStream(inp_stream);
	    ret=inp.readObject();
	}
	catch(Exception e) {
	    System.err.println(e);
	}
	return ret;
    }



    public String GetString() {
	if(data != null)
	    return (String)GetObject();
	return null;
    }


    public int GetInt() {
	ByteArrayInputStream in_stream=new ByteArrayInputStream(data);
	DataInputStream      inp=new DataInputStream(in_stream);
	int                  retval=0;
	int                  initial_bytes=data.length, bytes_read=0;

	try {
	    retval=inp.readInt();
	}
	catch(Exception e) {
	    System.err.println(e);
	    return retval;
	}
	return retval;	
    }


    public long GetLong() {
	ByteArrayInputStream in_stream=new ByteArrayInputStream(data);
	DataInputStream      inp=new DataInputStream(in_stream);
	long                 retval=0;
	int                  initial_bytes=data.length, bytes_read=0;

	try {
	    retval=inp.readLong();
	}
	catch(Exception e) {
	    System.err.println(e);
	    return retval;
	}
	return retval;
    }
    





    /** Adds new_data at <em>start</em> of existing data */
    public void Prepend(byte new_data[]) {
	byte  retval[]=null;
	int   i=0;
	if(data == null) {
	    data=new_data;
	    return;
	}
	retval=new byte[new_data.length + data.length];
	System.arraycopy(new_data, 0, retval, 0, new_data.length);
	System.arraycopy(data, 0, retval, new_data.length, data.length);
	data=retval;
    }


    public void Prepend(int i) {
	ByteArrayOutputStream out_stream=new ByteArrayOutputStream();
	DataOutputStream      out=new DataOutputStream(out_stream);
	try {
	    out.writeInt(i);
	}
	catch(Exception e) {
	    System.err.println(e);
	}
	Prepend(out_stream.toByteArray());
    }



    public void Prepend(long l) {
	ByteArrayOutputStream out_stream=new ByteArrayOutputStream();
	DataOutputStream      out=new DataOutputStream(out_stream);
	try {
	    out.writeLong(l);
	}
	catch(Exception e) {
	    System.err.println(e);
	}
	Prepend(out_stream.toByteArray());
    }




    public void Prepend(Serializable obj) {
	ByteArrayOutputStream out_stream=new ByteArrayOutputStream();
	ObjectOutputStream    out;
	
	try {
	    out=new ObjectOutputStream(out_stream);
	    out.writeObject(obj);
	    Prepend(out_stream.toByteArray());
	}
	catch(Exception e) {
	    System.err.println(e);
	}	
    }




    public void Append(byte new_data[]) {
	byte  retval[]=null;
	int   i=0;
	if(data == null) {
	    data=new_data;
	    return;
	}
	retval=new byte[new_data.length + data.length];
	System.arraycopy(data, 0, retval, 0, data.length);
	System.arraycopy(new_data, 0, retval, data.length, new_data.length);
	data=retval;
    }



    public void Append(int i) {
	ByteArrayOutputStream out_stream=new ByteArrayOutputStream();
	DataOutputStream      out=new DataOutputStream(out_stream);
	try {
	    out.writeInt(i);
	}
	catch(Exception e) {
	    System.err.println(e);
	}
	Append(out_stream.toByteArray());
    }



    public void Append(long l) {
	ByteArrayOutputStream out_stream=new ByteArrayOutputStream();
	DataOutputStream      out=new DataOutputStream(out_stream);
	try {
	    out.writeLong(l);
	}
	catch(Exception e) {
	    System.err.println(e);
	}
	Append(out_stream.toByteArray());	
    }



    public void Append(Serializable obj) {
	ByteArrayOutputStream out_stream=new ByteArrayOutputStream();
	ObjectOutputStream    out;
	
	try {
	    out=new ObjectOutputStream(out_stream);
	    out.writeObject(obj);
	    Append(out_stream.toByteArray());
	}
	catch(Exception e) {
	    System.err.println(e);
	}	
    }


    
    private void RemoveLeft(int num_bytes) throws Exception {
	if(data == null) {
	    System.err.println("Header.RemoveLeft(): data is null !");
	    return;
	}
	int new_data_len=data.length - num_bytes;
	if(new_data_len < 0)
	    throw new Exception("Header.RemoveLeft(): new data size would be " +
				new_data_len + " if removing " + num_bytes + " from it ");
	if(new_data_len == 0) {
	    data=null;
	    return;
	}
	byte new_data[]=new byte[new_data_len];
	System.arraycopy(data, num_bytes, new_data, 0, new_data_len);
	data=new_data;	
    }




    public int RemoveInt() throws Exception {
	ByteArrayInputStream in_stream=new ByteArrayInputStream(data);
	DataInputStream      inp=new DataInputStream(in_stream);
	int                  retval=0;
	int                  initial_bytes=data.length, bytes_read=0;
	retval=inp.readInt();
	bytes_read=initial_bytes - in_stream.available();
	RemoveLeft(bytes_read);
	return retval;
    }



    public long RemoveLong() throws Exception {
	ByteArrayInputStream in_stream=new ByteArrayInputStream(data);
	DataInputStream      inp=new DataInputStream(in_stream);
	long                 retval=0;
	int                  initial_bytes=data.length, bytes_read=0;
	retval=inp.readLong();
	bytes_read=initial_bytes - in_stream.available();
	RemoveLeft(bytes_read);
	return retval;
    }


    public Object RemoveObject() throws Exception {
	ByteArrayInputStream in_stream=new ByteArrayInputStream(data);
	ObjectInputStream    inp=new ObjectInputStream(in_stream);
	Object               retval=null;
	int                  initial_bytes=data.length, bytes_read=0;
	retval=inp.readObject();
	bytes_read=initial_bytes - in_stream.available();
	RemoveLeft(bytes_read);
	return retval;
    }



    public String toString() {	
	StringBuffer ret=new StringBuffer();
	if(data != null) {
	    for(int i=0; i < data.length; i++)
		ret.append((char)data[i]);
	}
	return ret.toString();
    }


    public Object clone() throws CloneNotSupportedException {
	return super.clone();
    }



    public static void main(String args[]) {
//  	Header msg1=new Header(new String("Bela Ban").getBytes());

//  	msg1.Prepend(new String("Jeannette Fechner und ").getBytes());
//  	msg1.Append(new String(" leben in Ithaca").getBytes());

//  	System.out.println(new String(msg1.GetData()));


	Header msg=new Header();
	int        l;
	String     s;


	try {

// 	    msg.Append(24);
// 	    msg.Append(25);
// 	    msg.Append((long)322649);

	    
// 	    l=msg.RemoveInt();
// 	    System.out.println(l);

// 	    l=msg.RemoveInt();
// 	    System.out.println(l);

// 	    long ll=msg.RemoveLong();
// 	    System.out.println(ll);


	    msg.Append("Hello world");
	    msg.Append(" from Bela");
	    msg.Prepend("Msg from Ralph: ");
	    msg.Prepend(322649);
	    msg.Prepend((long)1234567890);


	    long ll=msg.RemoveLong();
	    System.out.println(ll);

	    l=msg.RemoveInt();
	    System.out.println(l);

	    s=(String)msg.RemoveObject();
	    System.out.println(s);

	    s=(String)msg.RemoveObject();
	    System.out.println(s);

	    s=(String)msg.RemoveObject();
	    System.out.println(s);	    
	}
	catch(Exception e) {
	    System.err.println(e);
	}
	    
    }


}
