/*
 * Decompiled with CFR 0.152.
 */
package JavaGroups;

import JavaGroups.Address;
import JavaGroups.OID;
import java.net.InetAddress;

public class UnicastAddress
extends Address {
    private OID oid = OID.MakePid();
    private int port;
    private String groupname;

    public UnicastAddress() {
    }

    public UnicastAddress(OID o) {
        this.oid = o;
    }

    public UnicastAddress(String dest_addr, int dest_port) {
        try {
            this.oid.SetAddress(InetAddress.getByName(dest_addr));
            this.oid.SetProcessId(0L);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        this.port = dest_port;
    }

    public UnicastAddress(InetAddress dest_addr, int dest_port) {
        this.oid.SetAddress(dest_addr);
        this.oid.SetProcessId(0L);
        this.port = dest_port;
    }

    public UnicastAddress(int local_port) {
        this.port = local_port;
    }

    public OID GetOid() {
        return this.oid;
    }

    public InetAddress GetAddress() {
        return this.oid.GetAddress();
    }

    public int GetPort() {
        return this.port;
    }

    public long GetProcessId() {
        return this.oid.GetProcessId();
    }

    public String GetGroupName() {
        return this.groupname;
    }

    public void SetOid(OID o) {
        this.oid = o;
    }

    public void SetPort(int p) {
        this.port = p;
    }

    public void SetGroupName(String gn) {
        this.groupname = gn;
    }

    public void SetProcessId(long id) {
        this.oid.SetProcessId(id);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(String.valueOf(this.oid) + ":");
        if (this.port != 0) {
            ret.append(this.port);
        } else {
            ret.append("<no port>");
        }
        ret.append(":");
        if (this.groupname != null) {
            ret.append(this.groupname);
        } else {
            ret.append("<no grp>");
        }
        return ret.toString();
    }
}

