/*
 * Decompiled with CFR 0.152.
 */
package JavaGroups.Protocols;

import JavaGroups.Message;
import JavaGroups.MessageQueue;
import JavaGroups.Protocol;
import JavaGroups.Protocols.UDP;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;

public class UdpReceiverThread
extends Thread {
    private UDP udp_prot;
    private final int RECEIVE_BUFFER_SIZE = 65535;
    private int in_port;
    private DatagramSocket sock;

    public UdpReceiverThread(UDP udp) {
        this.udp_prot = udp;
        this.in_port = this.udp_prot.GetInPort();
        try {
            if (this.in_port <= 0) {
                this.sock = new DatagramSocket();
                this.in_port = this.sock.getLocalPort();
                this.udp_prot.SetInPort(this.in_port);
            } else {
                this.sock = new DatagramSocket(this.in_port);
            }
        }
        catch (Exception e) {
            System.err.println(e);
            return;
        }
    }

    public void run() {
        byte[] receive_buf = new byte[65535];
        MessageQueue receive_queue = this.udp_prot.GetReceiveQueue();
        while (true) {
            try {
                while (true) {
                    Message msg;
                    Protocol receive_prot = this.udp_prot.GetReceiveProtocol();
                    Protocol send_prot = this.udp_prot.GetSendProtocol();
                    if (send_prot != null) {
                        msg = receive_queue.Remove();
                        if (receive_prot != null) {
                            receive_prot.Receive(msg);
                            continue;
                        }
                        System.err.println("UDP protocol: layer above is not available !");
                        continue;
                    }
                    DatagramPacket packet = new DatagramPacket(receive_buf, receive_buf.length);
                    this.sock.receive(packet);
                    ByteArrayInputStream inp_stream = new ByteArrayInputStream(packet.getData());
                    ObjectInputStream inp = new ObjectInputStream(inp_stream);
                    msg = (Message)inp.readObject();
                    if (receive_prot == null) {
                        System.err.println("UDP protocol: no layer above us available !");
                        continue;
                    }
                    receive_prot.Receive(msg);
                }
            }
            catch (Exception e) {
                System.err.println(e);
                continue;
            }
            break;
        }
    }
}

