/*
 * Decompiled with CFR 0.152.
 */
package JavaGroups.Protocols;

import JavaGroups.Message;
import JavaGroups.Protocol;
import java.util.Properties;
import java.util.Vector;

public class NAK
implements Protocol {
    private Protocol send_prot;
    private Protocol receive_prot;
    private Vector msgs = new Vector();
    private Properties properties;
    private long timeout = 3000L;
    private RetransmissionThread thread = new RetransmissionThread();
    private boolean trace = false;

    public Properties GetProperties() {
        return this.properties;
    }

    public String GetName() {
        return "NAK";
    }

    public Protocol GetReceiveProtocol() {
        return this.receive_prot;
    }

    public Protocol GetSendProtocol() {
        return this.send_prot;
    }

    public void SetProperties(Properties props) {
        this.properties = props;
        String sl = props.getProperty("timeout");
        if (sl != null) {
            this.timeout = Integer.parseInt(sl);
        }
        if ((sl = props.getProperty("trace")) != null) {
            this.trace = new Boolean(sl);
        }
    }

    public void SetReceiveProtocol(Protocol receive_protocol) {
        this.receive_prot = receive_protocol;
    }

    public void SetSendProtocol(Protocol send_protocol) {
        this.send_prot = send_protocol;
    }

    public void Receive(Message msg) {
        long msg_id = msg.GetReplyId();
        try {
            Vector vector = this.msgs;
            synchronized (vector) {
                int i = 0;
                while (i < this.msgs.size()) {
                    Value val = (Value)this.msgs.elementAt(i);
                    if (val.id == msg_id) {
                        this.receive_prot.Receive(msg);
                        this.msgs.removeElementAt(i);
                        Object var6_7 = null;
                        return;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void Send(Message msg) throws Exception {
        Long msg_id = new Long(msg.GetMessageId());
        try {
            Vector vector = this.msgs;
            synchronized (vector) {
                int i = 0;
                while (i < this.msgs.size()) {
                    Value val = (Value)this.msgs.elementAt(i);
                    if (val.id == msg.GetMessageId()) {
                        System.err.println("NAK.Send(): message #" + msg_id + " is already registered");
                        Object var5_7 = null;
                        return;
                    }
                    ++i;
                }
                this.msgs.addElement(new Value(msg));
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        this.send_prot.Send(msg);
    }

    public void StartWork() {
        if (this.thread == null) {
            this.thread = new RetransmissionThread();
        }
        this.thread.start();
    }

    public void StopWork() {
        if (this.thread != null) {
            this.thread.stop();
        }
        this.thread = null;
    }

    public String toString() {
        return "Protocol NAK";
    }

    private class Value {
        long id;
        long send_time;
        Message msg;

        Value(Message m) {
            NAK.this = NAK.this;
            this.id = m.GetMessageId();
            this.msg = m;
            this.send_time = System.currentTimeMillis();
        }

        public String toString() {
            return "id=" + this.id;
        }
    }

    private class RetransmissionThread
    extends Thread {
        long current_time;
        long delta;
        Value val;
        Message m;

        public void run() {
            while (true) {
                Vector vector = NAK.this.msgs;
                synchronized (vector) {
                    int i = 0;
                    while (i < NAK.this.msgs.size()) {
                        this.val = (Value)NAK.this.msgs.elementAt(i);
                        this.current_time = System.currentTimeMillis();
                        this.delta = this.current_time - this.val.send_time;
                        if (this.delta >= NAK.this.timeout) {
                            try {
                                this.m = (Message)this.val.msg.clone();
                                if (NAK.this.trace) {
                                    System.out.println("---- NAK: msg #" + this.m.GetMessageId() + " is retransmitted");
                                }
                                NAK.this.send_prot.Send(this.m);
                            }
                            catch (CloneNotSupportedException ce) {
                                System.err.println(ce);
                            }
                            catch (Exception ex) {
                                System.err.println(ex);
                            }
                        }
                        ++i;
                    }
                }
                try {
                    Thread.sleep(NAK.this.timeout);
                    continue;
                }
                catch (Exception e) {
                    System.err.println(e);
                    continue;
                }
                break;
            }
        }

        RetransmissionThread() {
            NAK.this = NAK.this;
        }
    }
}

