/*
 * Decompiled with CFR 0.152.
 */
package JavaGroups.Protocols;

import JavaGroups.Message;
import JavaGroups.MessageQueue;
import JavaGroups.Protocol;
import java.util.Properties;

public class DEBUG
implements Protocol {
    private Protocol send_prot;
    private Protocol receive_prot;
    private MessageQueue receive_queue = new MessageQueue();
    private MessageQueue send_queue = new MessageQueue();
    private DebugSenderThread sender_thread;
    private DebugReceiverThread receiver_thread;
    private Properties properties;
    private long sender_sleep_time = 1000L;
    private long receiver_sleep_time = 1000L;

    public Properties GetProperties() {
        return this.properties;
    }

    public String GetName() {
        return "DEBUG";
    }

    public Protocol GetReceiveProtocol() {
        return this.receive_prot;
    }

    public Protocol GetSendProtocol() {
        return this.send_prot;
    }

    public MessageQueue GetSendQueue() {
        return this.send_queue;
    }

    public MessageQueue GetReceiveQueue() {
        return this.receive_queue;
    }

    public void SetProperties(Properties props) {
        String sl = props.getProperty("sender_sleep_time");
        if (sl != null) {
            this.sender_sleep_time = Long.parseLong(sl);
        }
        if ((sl = props.getProperty("receiver_sleep_time")) != null) {
            this.receiver_sleep_time = Long.parseLong(sl);
        }
    }

    public void SetReceiveProtocol(Protocol receive_protocol) {
        this.receive_prot = receive_protocol;
    }

    public void SetSendProtocol(Protocol send_protocol) {
        this.send_prot = send_protocol;
    }

    public void Receive(Message msg) {
        try {
            this.receive_queue.Add(msg);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void Send(Message msg) throws Exception {
        this.send_queue.Add(msg);
    }

    public void StartWork() {
        this.sender_thread = new DebugSenderThread();
        this.receiver_thread = new DebugReceiverThread();
        this.receiver_thread.start();
        this.sender_thread.start();
    }

    public void StopWork() {
        if (this.receiver_thread != null) {
            this.receiver_thread.stop();
            this.receiver_thread = null;
        }
        if (this.sender_thread != null) {
            this.sender_thread.stop();
            this.sender_thread = null;
        }
    }

    public String toString() {
        return "Protocol DEBUG (sender_sleep_time=" + this.sender_sleep_time + ";receiver_sleep_time=" + this.receiver_sleep_time + ")";
    }

    private class DebugReceiverThread
    extends Thread {
        Message msg;

        public void run() {
            while (true) {
                try {
                    while (true) {
                        System.out.println("Size of receive msg queue: " + DEBUG.this.receive_queue.Size());
                        this.msg = DEBUG.this.receive_queue.Remove();
                        if (DEBUG.this.receive_prot != null) {
                            DEBUG.this.receive_prot.Receive(this.msg);
                        }
                        Thread.sleep(DEBUG.this.receiver_sleep_time);
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                    continue;
                }
                break;
            }
        }

        DebugReceiverThread() {
            DEBUG.this = DEBUG.this;
        }
    }

    private class DebugSenderThread
    extends Thread {
        Message msg;

        public void run() {
            while (true) {
                try {
                    while (true) {
                        System.out.println("Size of send msg queue: " + DEBUG.this.send_queue.Size());
                        this.msg = DEBUG.this.send_queue.Remove();
                        if (DEBUG.this.send_prot != null) {
                            DEBUG.this.send_prot.Send(this.msg);
                        }
                        Thread.sleep(DEBUG.this.sender_sleep_time);
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                    continue;
                }
                break;
            }
        }

        DebugSenderThread() {
            DEBUG.this = DEBUG.this;
        }
    }
}

