/*
 * Decompiled with CFR 0.152.
 */
package JavaGroups;

import JavaGroups.Message;
import JavaGroups.MessageQueue;
import java.util.Hashtable;
import java.util.Vector;

public class MessageCorrelator {
    private Hashtable msgs = new Hashtable();

    public void AddRequest(Message m) {
        Hashtable hashtable = this.msgs;
        synchronized (hashtable) {
            this.msgs.put(new Long(m.GetMessageId()), new MessageQueue());
        }
    }

    public boolean AddResponse(Message m) throws Exception {
        long id = m.GetReplyId();
        MessageQueue mq = null;
        if (id <= 0L) {
            System.err.println("MessageCorrelator.AddResponse(): message id " + id + " is not valid");
            return false;
        }
        Hashtable hashtable = this.msgs;
        synchronized (hashtable) {
            mq = (MessageQueue)this.msgs.get(new Long(id));
            if (mq == null) {
                boolean bl = false;
                Object var7_6 = null;
                return bl;
            }
        }
        mq.Add(m);
        return true;
    }

    public Message GetResponse(long req_id, long timeout) {
        Message retval = null;
        MessageQueue mq = null;
        if (req_id <= 0L) {
            System.err.println("MessageCorrelator.GetResponse(): message id " + req_id + " not found in correlation table");
            return null;
        }
        Hashtable hashtable = this.msgs;
        synchronized (hashtable) {
            mq = (MessageQueue)this.msgs.get(new Long(req_id));
            if (mq == null) {
                System.err.println("MessageCorrelator.GetResponse(): no request found with id=" + req_id);
                Message message = null;
                Object var9_8 = null;
                return message;
            }
        }
        try {
            retval = timeout <= 0L ? mq.Remove() : mq.Remove(timeout);
        }
        catch (Exception e) {
            System.out.println(e);
            retval = null;
        }
        return retval;
    }

    public Vector GetResponses(long req_id, int expected_responses, long timeout) {
        Vector<Message> retval = new Vector<Message>();
        long start_time = System.currentTimeMillis();
        long time_spent = 0L;
        int num_responses = 0;
        while (num_responses < expected_responses && time_spent < timeout) {
            Message msg = this.GetResponse(req_id, timeout - time_spent);
            if (msg != null) {
                retval.addElement(msg);
                ++num_responses;
            }
            time_spent = System.currentTimeMillis() - start_time;
        }
        return retval;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.msgs);
        return ret.toString();
    }
}

