/*
 * Decompiled with CFR 0.152.
 */
package JavaGroups;

import JavaGroups.Address;
import JavaGroups.Dispatcher;
import JavaGroups.Group;
import JavaGroups.McastAddress;
import JavaGroups.Message;
import JavaGroups.MessageQueue;
import JavaGroups.MethodCall;
import JavaGroups.OID;
import JavaGroups.RpcMessage;
import JavaGroups.SingleObject;
import JavaGroups.UnicastAddress;
import java.io.Serializable;
import java.util.Vector;

public class DispatcherThread
extends Thread {
    private Dispatcher dispatcher;

    public DispatcherThread(Dispatcher d) {
        this.dispatcher = d;
    }

    private void DispatchMcastMessage(McastAddress dest, Message msg) {
        String group_name = dest.GetGroupName();
        if (group_name == null) {
            System.err.println("DispatcherThread.DispatchMcastMessage(): group name is null !");
            return;
        }
        this.DeliverToGroup(group_name, msg);
    }

    private void DeliverToGroup(String group_name, Message msg) {
        Group target_group = this.dispatcher.FindGroup(group_name);
        if (target_group == null) {
            System.err.println("DispatcherThread.DeliverToGroup(): group " + group_name + " was not found");
            return;
        }
        Vector members = target_group.GetMembers();
        int i = 0;
        while (i < members.size()) {
            this.DeliverToObject((OID)members.elementAt(i), msg);
            ++i;
        }
    }

    private void DeliverToObject(OID oid, Message msg) {
        Object dest_object = this.dispatcher.GetRegisteredObjects().get(oid);
        if (dest_object == null) {
            System.err.println("DispatcherThread.DeliverToObject(): object with OID=" + oid + " not found");
            return;
        }
        if (msg instanceof RpcMessage) {
            this.DeliverToObjectAsMethod(dest_object, msg);
            return;
        }
        if (msg instanceof Message) {
            if (!(dest_object instanceof SingleObject)) {
                System.err.println("DispatcherThread.DeliverToObject(): destination object does not implement interface SingleObject. Cannot deliver message !");
                return;
            }
            ((SingleObject)dest_object).Receive(msg);
            return;
        }
        System.err.println("DispatcherThread.DeliverToObject(): message of type " + msg.getClass().getName() + " not understood !");
    }

    private void DeliverToObjectAsMethod(Object dest_object, Message msg) {
        block6: {
            Object retval = null;
            RpcMessage rpc = (RpcMessage)msg;
            MethodCall method_call = rpc.GetMethodCall();
            if (method_call == null) {
                System.err.println("DispatcherThread.DeliverToObject(): RpcMessage does not contain a MethodCall object !");
                return;
            }
            retval = method_call.Invoke(dest_object);
            if (rpc.IsOneway()) break block6;
            RpcMessage rsp = (RpcMessage)rpc.MakeReply();
            rsp.SetOneway(true);
            if (retval != null) {
                if (!(retval instanceof Serializable)) {
                    System.out.println("DispatcherThread.DeliverToObject(): return value of method invocation is not serializable ! I return void");
                } else {
                    rsp.SetResponse((Serializable)retval);
                }
            }
            try {
                this.dispatcher.Send(rsp);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    private void DispatchUnicastMessage(UnicastAddress dest, Message msg) {
        String group_name = dest.GetGroupName();
        OID oid = dest.GetOid();
        long object_id = oid.GetObjectId();
        if (group_name != null) {
            if (object_id <= 0L) {
                this.DeliverToGroup(group_name, msg);
            } else {
                this.DeliverToObject(oid, msg);
            }
        } else {
            if (object_id <= 0L) {
                System.err.println("DispatcherThread.DispatchUnicastMessage(): both group name and object id are null: " + dest);
                return;
            }
            this.DeliverToObject(oid, msg);
        }
    }

    private void HandleMessage(Message msg) {
        Address dest = msg.GetDestinationAddress();
        if (dest == null) {
            System.err.println("DispatcherThread.HandleMessage(): message has empty destination address !");
            return;
        }
        if (dest instanceof McastAddress) {
            this.DispatchMcastMessage((McastAddress)dest, msg);
        } else if (dest instanceof UnicastAddress) {
            this.DispatchUnicastMessage((UnicastAddress)dest, msg);
        } else {
            System.err.println("DispatcherThread.HandleMessage(): message type is not known (must be mcast, ucast or multiple) !");
            return;
        }
    }

    public void run() {
        MessageQueue dispatch_queue = this.dispatcher.GetDispatchQueue();
        while (true) {
            try {
                while (true) {
                    Message msg = dispatch_queue.Remove();
                    this.HandleMessage(msg);
                }
            }
            catch (Exception e) {
                System.err.println(e);
                continue;
            }
            break;
        }
    }
}

