#!/bin/csh -f

set usage = "USAGE: samplecount.sh <cnffile> <iterations> <samples> <slack> [options for approxcount]"
set defaultoptions = "Default options for approxcount: -lowerbound -equiv -knuth -exact_count -100"

echo "SampleCount version 1.0"
echo "Copyright Cornell University, 2007"
echo

if ($#argv < 4) then
    echo $usage
    echo
    echo "       $defaultoptions"
    echo "       Options for Approxcount include options to Samplesat/Walksat for sampling."
    echo "       See approxcount -h for parameter tuning options for good sampling."
    echo
    echo "       See publication 'From Sampling to Model Counting' in IJCAI-07 for details."
    exit(1)
endif

# check that every required executible is present
foreach reqd_file (approxcount cachet bc)
    if (! -X $reqd_file) then
      echo "ERROR: cannot find required executable '$reqd_file' in the path"
      exit(1)
    endif
end

echo "Command line: samplecount.sh $argv"

set cnffile    = $1
set iterations = $2
set samples    = $3
set slack      = $4

set nextseed = 0      # make approxcount generate a seed in the beginning

set hostname = `uname -n | cut -d'.' -f1`
set tmpfile = "/tmp/tmp-samplecount-$hostname-$$"

set commandline = "approxcount -lowerbound -equiv -knuth -exact_count -100 -samples $samples -lb_slack $slack"
set a = 4
while ($a < $#argv)
    @ a += 1
    set nextarg = $argv[$a]
    set commandline = "$commandline $nextarg"
end
echo "Executing: $commandline < $cnffile"
echo "Starting with random seed = 0"
echo "Passing random seed from one iteration to another" 

set iter = 0
set mincount = -1
while ($iter < $iterations)
    @ iter += 1
    $commandline -seed $nextseed < $cnffile > $tmpfile
    set count = `grep "lowerbound:" $tmpfile | cut -d':' -f2`
    set countstr = `tail -n 1 $tmpfile`
    set nextseed = `grep "last random number" $tmpfile | cut -d' ' -f5`
    echo "  Iteration $iter/$iterations lowerbound: $count"
    echo "              $countstr"
#    if ($mincount == -1 || $count < $mincount) then
#        set mincount = count;
#    endif
end

#echo "Final lowerbound: $mincount"
echo "Final lowerbound: minimum of the above $iterations counts"
set confidence = `echo "scale=3; 100 * (1 - e(-$slack * $iterations * l(2)))" | bc -l`
echo "Correctness confidence: $confidence %"

/bin/rm -f $tmpfile
