#include "Solutions.h"

Solutions::Solutions()
{
	numSolns = 0;
	sum = 0;
	(*this).clear();
}	

Solutions::~Solutions()
{

}

//Returns number of NON-unique solutions found
int Solutions::getSolnCount() {
	return numSolns;
}

//Returns number of UNIQUE solutions found
int Solutions::getUniqueSolnCount() {
	return this->size();
}


void Solutions::addSoln(SATSolution soln, long int num) {
	numSolns++;
	sum += num;

	(*this)[soln].push_back(num);
}

/*Outputs all of the solution finding data, with solutions in "01" bitstring format*/
void Solutions::printData(ostream *out) {
	solnMapItr itr = this->begin();
	longVec times;
	
	while (itr != this->end()) {
		out->operator << ("SOLN\t");
		out->operator << (itr->first.c_str());
		times = itr->second;
		for(unsigned int i = 0; i < times.size(); i++) {
			out->operator << ("\t");
			out->operator << (times[i]);
		}
		out->operator << (endl);
		itr++;
	}
}

// Ashish: Outputs all solutions in the native lexicographic order
//         and the frequency of their occurrence
void Solutions::printSolnsWithFreq(ostream & out) {
	solnMapItr itr = this->begin();
	int i=0;
	
	while (itr != this->end()) {
		out << "SOLN " << ++i 
			<< ", FREQ=" << itr->second.size() 
			<< " : \t" << itr->first.c_str() 
			<< endl;
		itr++;
	}
}

// Ashish: Outputs all solutions in the Hamming distance order (starting from
//         the lexically first) and the frequency of their occurrence
void Solutions::printSolnsWithFreqHammDistSort(ostream & out) {
	const int numUniqueSolns = getUniqueSolnCount();
	vector<pair<SATSolution, bool> > solns(numUniqueSolns);
	int i=0;

	// copy over all solutions to the temp vector of solutions
	solnMapItr itr = this->begin();
	while (itr != this->end()) {
		solns[i].first = itr->first; // stores the string for soln i
		solns[i].second = false;     // stores whether soln i has been printed
		++i; ++itr;
	}

	// start by printing the first solution
	out << "SOLN 1"
		<< ", FREQ=" << this->begin()->second.size() 
		<< ", HAM-DIST=0"
		<< " : \t" << this->begin()->first.c_str() 
		<< endl;
	int current_index = 0;
	solns[0].second = true;
	for (i=1; i<numUniqueSolns; ++i) {
		// find a solution that is closest to the current solution
		int min_index = 0;
		int min_dist = solns[0].first.length() + 1;
		for (int j=0; j<numUniqueSolns; ++j) {
			if (solns[j].second)
				continue;
			int new_dist = solns[current_index].first.hammingDistance(solns[j].first);
			if (new_dist < min_dist) {
				min_dist = new_dist;
				min_index = j;
			}
		}
		current_index = min_index;
		out << "SOLN " << current_index+1
			<< ", FREQ=" << this->find(solns[current_index].first)->second.size()
			<< ", HAM-DIST=" << min_dist
			<< " : \t" << solns[current_index].first.c_str() 
			<< endl;
		solns[current_index].second = true;
	}

    for (int i=0; i<numUniqueSolns; ++i) {
      for (int j=i+1; j<numUniqueSolns; ++j) {
        int dist = solns[i].first.hammingDistance(solns[j].first);
        cout << "\tPAIR-DIST (" << i << "," << j << ") = " << dist << endl;
      }
    }
}


