/*********************************************************************
 Copyright 2002-2003, Princeton University.  All rights reserved. 
 By using this software the USER indicates that he or she has read, 
 understood and will comply with the following:

 --- Princeton University hereby grants USER nonexclusive permission 
 to use, copy and/or modify this software for internal, noncommercial,
 research purposes only. Any distribution, including commercial sale 
 or license, of this software, copies of the software, its associated 
 documentation and/or modifications of either is strictly prohibited 
 without the prior consent of Princeton University.  Title to copyright
 to this software and its associated documentation shall at all times 
 remain with Princeton University.  Appropriate copyright notice shall 
 be placed on all software copies, and a complete copy of this notice 
 shall be included in all copies of the associated documentation.  
 No right is  granted to use in advertising, publicity or otherwise 
 any trademark, service mark, or the name of Princeton University. 


 --- This software and any associated documentation is provided "as is" 

 PRINCETON UNIVERSITY MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS 
 OR IMPLIED, INCLUDING THOSE OF MERCHANTABILITY OR FITNESS FOR A 
 PARTICULAR PURPOSE, OR THAT  USE OF THE SOFTWARE, MODIFICATIONS, OR 
 ASSOCIATED DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, 
 TRADEMARKS OR OTHER INTELLECTUAL PROPERTY RIGHTS OF A THIRD PARTY.  

 Princeton University shall not be liable under any circumstances for 
 any direct, indirect, special, incidental, or consequential damages 
 with respect to any claim by USER or any third party on account of 
 or arising from the use, or inability to use, this software or its 
 associated documentation, even if Princeton University has been advised
 of the possibility of those damages.
*********************************************************************/

#include "duaffle.h"
#include "config.h"

int main(int argc, char * * argv) {
  CSolver solver;
  cout << "Duaffle version 1.0NL: Dual-format QBF Solver (currently without learning)" << endl;
  cout << "Copyright Cornell University, 2006" << endl;
  cout << "Quaffle Copyright 2002-2003, Lintao Zhang, Princeton University, ALL RIGHTS RESERVED" << endl;
  cout << endl;
    
  if (argc < 2 || argc > 3) {
	cerr << "Usage: "<< argv[0] << " cnfdnf_file [time_limit]" << endl;
	return 2;
  }

  cout << "COMMAND LINE: "; 
  for (int i=0; i<argc; ++i)
	cout << argv[i] << " ";
  cout << endl;
  cout << "Running Duaffle-- (Duaffle without clause- or conflict-learning)" << endl;
  cout <<"Solving " << argv[1] << " ......" << endl;
  if (argc == 2) {
	solver.read_cnfdnf(argv[1]);
  }
  else {
	solver.read_cnfdnf(argv[1]);
	solver.params.time_limit = atoi(argv[2]);
  }
  solver.solve();
  if (solver.stats.outcome == SATISFIABLE) {
#ifdef OUTPUT_SOLUTION_E
    solver.print_solution_e0();   // Ashish: print "solution"
#endif
	cout << "Problem QSAT" << endl;
  }
  else if (solver.stats.outcome == UNSATISFIABLE) 
	cout << "Problem QUNSAT" << endl;
  else if (solver.stats.outcome == TIME_OUT) 
	cout << "Time out" << endl;

  // Ashish
  cout << "Num Variables\t\t" << solver.num_variables() << endl;
  cout << "Num Orig Clauses\t" << solver.stats.num_original_clauses << endl;
  cout << "Num Orig Cubes\t\t" << solver.stats.num_original_cubes << endl;
  cout << "Combining Operator\t" << (solver.get_combining_op()==AND ? "AND" : "OR") << endl;
  cout << "Num Exist Lits\t\t" << solver.stats.num_original_exist_literals << endl;
  cout << "Num Univ Lits\t\t" << solver.stats.num_original_univ_literals << endl;

  cout << "Num Decisions\t\t" << solver.stats.num_decisions << endl;
  cout << "Num Implications\t" << solver.stats.num_implications << endl;
  cout << "Num Conflicts\t\t" << solver.stats.num_conflicts << endl;
  cout << "Num SAT Leaves\t\t" << solver.stats.num_sat_leaves << endl;

  // Ashish
  cout << "Num Added Clauses\t" << solver.stats.num_added_clauses - solver.stats.num_original_clauses << endl;
  cout << "Num Added Cubes\t\t" << solver.stats.num_added_cubes - solver.stats.num_original_cubes << endl;

  cout << "Num Deleted Clauses\t" << solver.stats.num_deleted_clauses << endl;
  cout << "Num Deleted Cubes\t" << solver.stats.num_deleted_cubes << endl;
  cout << "Total Runtime\t\t" << (get_cpu_time() - solver.stats.start_cpu_time )/1000.0 << endl;
}	


