#include "Solutions.h"

Solutions::Solutions()
{
	numSolns = 0;
	sum = 0;
	(*this).clear();
}	

Solutions::~Solutions()
{

}

//Returns number of NON-unique solutions found
int Solutions::getSolnCount() {
	return numSolns;
}

//Returns number of UNIQUE solutions found
int Solutions::getUniqueSolnCount() {
	return this->size();
}


void Solutions::addSoln(SATSolution soln, long int num) {
	numSolns++;
	sum += num;

	(*this)[soln].push_back(num);
}

/*Outputs all of the solution finding data, with solutions in "01" bitstring format*/
void Solutions::printData(ostream *out) {
	solnMapItr itr = this->begin();
	longVec times;
	
	while (itr != this->end()) {
		out->operator << ("SOLN\t");
		out->operator << (itr->first.c_str());
		times = itr->second;
		for(int i = 0; i < times.size(); i++) {
			out->operator << ("\t");
			out->operator << (times[i]);
		}
		out->operator << (endl);
		itr++;
	}
}
