#!/usr/bin/python

import sys
import os
import shutil
import platform

if not os.path.exists("../RELEASE-1.5.5"):
	print "Missing directory: '../RELEASE-1.5.5'"
	print "Obtain ROUGE from http://berouge.com/"
	print "and unpack it into parent directory."
	sys.exit()

if not os.path.exists("data") or not os.path.exists("results"):
	print "Convert the DUC data first by running convdata04.py script."
	sys.exit()

if not os.path.exists("exec"):
	os.mkdir("exec")
	if os.path.isfile("../code/svm_sfour_learn"):
		print "Using executables from ../code"
		shutil.copy("../code/svm_sfour_learn", "exec")
		shutil.copy("../code/svm_sfour_classify", "exec")
	else:
		pf = platform.system()
		print "Using precompiled binaries"
		print "Platform: " + pf
		if pf == "Linux":
			shutil.copy("../binaries/linux/svm_sfour_learn", "exec")
			shutil.copy("../binaries/linux/svm_sfour_classify", "exec")
		elif pf == "Windows":
			shutil.copy("../binaries/windows/svm_sfour_learn.exe", "exec")
			shutil.copy("../binaries/windows/svm_sfour_classify.exe", "exec")
		else:
			print "Unrecognized platform. Please compile the source in ../code/"
			print "directory or copy appropriate ones into exec/ directory"

os.chdir("exec")
# create index file with a single training example
f = open("one", "w")
f.write("../data/svm30003\n")
f.close()

print "Training..."
os.system("./svm_sfour_learn -c 1 -e 0.01 -w 0 one mdl")

print "Classifying..."
os.system("./svm_sfour_classify one mdl out")

print "Evaluating..."
os.system("python ../../scripts/unpk4b2.py one out")
os.system("../../scripts/roug.py")

os.chdir("..")
print "Done."


