 #include "matsock.h"
 #include <stdlib.h>
/* --------------------------------------------------- */
/* Automatically generated by mwrap                    */
/* --------------------------------------------------- */

/* Code generated by mwrap */
/*
  Copyright statement for mwrap:

  mwrap -- MEX file generation for MATLAB and Octave
  Copyright (c) 2007-2008 David Bindel

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  You may distribute a work that contains part or all of the source code
  generated by mwrap under the terms of your choice.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/

#include <mex.h>
#include <stdio.h>
#include <string.h>


#ifndef ulong
#  define ulong unsigned long
#endif
#ifndef uint
#  define uint  unsigned int
#endif
#ifndef uchar
#  define uchar unsigned char
#endif


/*
 * Records for call profile.
 */
int* mexprofrecord_= NULL;


/*
 * Support routines for copying data into and out of the MEX stubs
 */

void* mxWrapGetP(const mxArray* a, const char* fmt, const char** e)
{
    void* p = 0;
    mxArray* ap;
    if (mxGetClassID(a) == mxDOUBLE_CLASS && 
        mxGetM(a)*mxGetN(a) == 1 && *mxGetPr(a) == 0)
        return p;
    if (mxIsChar(a)) {
        char pbuf[128];
        mxGetString(a, pbuf, sizeof(pbuf));
        sscanf(pbuf, fmt, &p);
    } 
#ifdef R2008OO
    else if (ap = mxGetProperty(a, 0, "mwptr")) {
        return mxWrapGetP(ap, fmt, e);
    }
#endif
    if (p == 0)
        *e = "Invalid pointer";
    return p;
}

mxArray* mxWrapCreateP(void* p, const char* fmt)
{
    if (p == 0) {
        mxArray* z = mxCreateDoubleMatrix(1,1, mxREAL);
        *mxGetPr(z) = 0;
        return z;
    } else {
        char pbuf[128];
        sprintf(pbuf, fmt, p);
        return mxCreateString(pbuf);
    }
}

mxArray* mxWrapStrncpy(const char* s)
{
    if (s) {
        return mxCreateString(s);
    } else {
        mxArray* z = mxCreateDoubleMatrix(1,1, mxREAL);
        *mxGetPr(z) = 0;
        return z;
    }
}

double mxWrapGetScalar(const mxArray* a, const char** e)
{
    if (!a || mxGetClassID(a) != mxDOUBLE_CLASS || mxGetM(a)*mxGetN(a) != 1) {
        *e = "Invalid scalar argument";
        return 0;
    }
    return *mxGetPr(a);
}

char* mxWrapGetString(const mxArray* a, const char** e)
{
    char* s;
    int slen;
    if (!a || (!mxIsChar(a) && mxGetM(a)*mxGetN(a) > 0)) {
        *e = "Invalid string argument";
        return NULL;
    }
    slen = mxGetM(a)*mxGetN(a) + 1;
    s = (char*) mxMalloc(slen);
    if (mxGetM(a)*mxGetN(a) == 0)
        *s = 0;
    else
        mxGetString(a, s, slen);
    return s;
}


#define mxWrapGetArrayDef(func, T) \
T* func(const mxArray* a, const char** e)     \
{ \
    T* array; \
    int arraylen; \
    int i; \
    T* p; \
    double* q; \
    if (!a || mxGetClassID(a) != mxDOUBLE_CLASS) { \
        *e = "Invalid array argument"; \
        return 0; \
    } \
    arraylen = mxGetM(a)*mxGetN(a); \
    array = (T*) mxMalloc(mxGetM(a)*mxGetN(a) * sizeof(T)); \
    p = array; \
    q = mxGetPr(a); \
    for (i = 0; i < arraylen; ++i) \
        *p++ = (T) (*q++); \
    return array; \
}


#define mxWrapCopyDef(func, T) \
void func(mxArray* a, const T* q, int n) \
{ \
    int i; \
    double* p = mxGetPr(a); \
    for (i = 0; i < n; ++i) \
        *p++ = *q++; \
}


#define mxWrapReturnDef(func, T) \
mxArray* func(const T* q, int m, int n) \
{ \
    int i; \
    double* p; \
    if (!q) { \
        return mxCreateDoubleMatrix(0,0, mxREAL); \
    } else { \
        mxArray* a = mxCreateDoubleMatrix(m,n, mxREAL); \
        p = mxGetPr(a); \
        for (i = 0; i < m*n; ++i) \
            *p++ = *q++; \
        return a; \
    } \
}


#define mxWrapGetScalarZDef(func, T, ZT, setz) \
void func(T* z, const mxArray* a) \
{ \
    double* pr = mxGetPr(a); \
    double* pi = mxGetPi(a); \
    setz(z, (ZT) *pr, (pi ? (ZT) *pi : (ZT) 0)); \
}


#define mxWrapGetArrayZDef(func, T, ZT, setz) \
T* func(const mxArray* a, const char** e) \
{ \
    T* array; \
    int arraylen; \
    int i; \
    T* p; \
    double* qr; \
    double* qi; \
    if (!a || mxGetClassID(a) != mxDOUBLE_CLASS) { \
        *e = "Invalid array argument"; \
        return 0; \
    } \
    arraylen = mxGetM(a)*mxGetN(a); \
    array = (T*) mxMalloc(mxGetM(a)*mxGetN(a) * sizeof(T)); \
    p = array; \
    qr = mxGetPr(a); \
    qi = mxGetPi(a); \
    for (i = 0; i < arraylen; ++i) { \
        ZT val_qr = *qr++; \
        ZT val_qi = (qi ? (ZT) *qi++ : (ZT) 0); \
        setz(p, val_qr, val_qi); \
        ++p; \
    } \
    return array; \
}


#define mxWrapCopyZDef(func, T, real, imag) \
void func(mxArray* a, const T* q, int n) \
{ \
    int i; \
    double* pr = mxGetPr(a); \
    double* pi = mxGetPi(a); \
    for (i = 0; i < n; ++i) { \
        *pr++ = real(*q); \
        *pi++ = imag(*q); \
        ++q; \
    } \
}


#define mxWrapReturnZDef(func, T, real, imag) \
mxArray* func(const T* q, int m, int n) \
{ \
    int i; \
    double* pr; \
    double* pi; \
    if (!q) { \
        return mxCreateDoubleMatrix(0,0, mxCOMPLEX); \
    } else { \
        mxArray* a = mxCreateDoubleMatrix(m,n, mxCOMPLEX); \
        pr = mxGetPr(a); \
        pi = mxGetPi(a); \
        for (i = 0; i < m*n; ++i) { \
            *pr++ = real(*q); \
            *pi++ = imag(*q); \
            ++q; \
        } \
        return a; \
    } \
}

/* Array copier definitions */
mxWrapGetArrayDef(mxWrapGetArray_bool, bool)
mxWrapCopyDef    (mxWrapCopy_bool,     bool)
mxWrapReturnDef  (mxWrapReturn_bool,   bool)
mxWrapGetArrayDef(mxWrapGetArray_char, char)
mxWrapCopyDef    (mxWrapCopy_char,     char)
mxWrapReturnDef  (mxWrapReturn_char,   char)
mxWrapGetArrayDef(mxWrapGetArray_double, double)
mxWrapCopyDef    (mxWrapCopy_double,     double)
mxWrapReturnDef  (mxWrapReturn_double,   double)
mxWrapGetArrayDef(mxWrapGetArray_float, float)
mxWrapCopyDef    (mxWrapCopy_float,     float)
mxWrapReturnDef  (mxWrapReturn_float,   float)
mxWrapGetArrayDef(mxWrapGetArray_int, int)
mxWrapCopyDef    (mxWrapCopy_int,     int)
mxWrapReturnDef  (mxWrapReturn_int,   int)
mxWrapGetArrayDef(mxWrapGetArray_long, long)
mxWrapCopyDef    (mxWrapCopy_long,     long)
mxWrapReturnDef  (mxWrapReturn_long,   long)
mxWrapGetArrayDef(mxWrapGetArray_size_t, size_t)
mxWrapCopyDef    (mxWrapCopy_size_t,     size_t)
mxWrapReturnDef  (mxWrapReturn_size_t,   size_t)
mxWrapGetArrayDef(mxWrapGetArray_uchar, uchar)
mxWrapCopyDef    (mxWrapCopy_uchar,     uchar)
mxWrapReturnDef  (mxWrapReturn_uchar,   uchar)
mxWrapGetArrayDef(mxWrapGetArray_uint, uint)
mxWrapCopyDef    (mxWrapCopy_uint,     uint)
mxWrapReturnDef  (mxWrapReturn_uint,   uint)
mxWrapGetArrayDef(mxWrapGetArray_ulong, ulong)
mxWrapCopyDef    (mxWrapCopy_ulong,     ulong)
mxWrapReturnDef  (mxWrapReturn_ulong,   ulong)

/* ---- feapcsock.mw: 30 ----
 * int fd = matsock_new_tcp(cstring hostname, int port);
 */
const char* stubids1_ = "o int = matsock_new_tcp(i cstring, i int)";

void mexStub1(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    char*       in0_ =0; /* hostname   */
    int         in1_;    /* port       */
    int         out0_;   /* fd         */

    in0_ = mxWrapGetString(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    in1_ = (int) mxWrapGetScalar(prhs[1], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    if (mexprofrecord_)
        mexprofrecord_[1]++;
    out0_ = matsock_new_tcp(in0_, in1_);
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;

mw_err_label:
    if (in0_)  mxFree(in0_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- feapcsock.mw: 32 ----
 * int fd = matsock_new_unix(cstring hostname);
 */
const char* stubids2_ = "o int = matsock_new_unix(i cstring)";

void mexStub2(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    char*       in0_ =0; /* hostname   */
    int         out0_;   /* fd         */

    in0_ = mxWrapGetString(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    if (mexprofrecord_)
        mexprofrecord_[2]++;
    out0_ = matsock_new_unix(in0_);
    plhs[0] = mxCreateDoubleMatrix(1, 1, mxREAL);
    *mxGetPr(plhs[0]) = out0_;

mw_err_label:
    if (in0_)  mxFree(in0_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- feapcsock.mw: 39 ----
 * matsock_close(int fd);
 */
const char* stubids3_ = "matsock_close(i int)";

void mexStub3(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    int         in0_;    /* fd         */

    in0_ = (int) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    if (mexprofrecord_)
        mexprofrecord_[3]++;
    matsock_close(in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- feapcsock.mw: 43 ----
 * matsock_recv(int fd, output cstring[1024] s, int 1024);
 */
const char* stubids4_ = "matsock_recv(i int, o cstring[x], i int)";

void mexStub4(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    int         in0_;    /* fd         */
    int         in1_;    /* 1024       */
    char*       out0_=0; /* s          */
    int         dim2_;   /* 1024       */

    dim2_ = (int) mxWrapGetScalar(prhs[2], &mw_err_txt_);

    in0_ = (int) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    in1_ = (int) mxWrapGetScalar(prhs[1], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    out0_ = (char*) mxMalloc(dim2_*sizeof(char));
    if (mexprofrecord_)
        mexprofrecord_[4]++;
    matsock_recv(in0_, out0_, in1_);
    plhs[0] = mxCreateString(out0_);

mw_err_label:
    if (out0_) mxFree(out0_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- feapcsock.mw: 47 ----
 * matsock_send(int fd, cstring s);
 */
const char* stubids5_ = "matsock_send(i int, i cstring)";

void mexStub5(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    int         in0_;    /* fd         */
    char*       in1_ =0; /* s          */

    in0_ = (int) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    in1_ = mxWrapGetString(prhs[1], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    if (mexprofrecord_)
        mexprofrecord_[5]++;
    matsock_send(in0_, in1_);

mw_err_label:
    if (in1_)  mxFree(in1_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- feapcsock.mw: 51 ----
 * matsock_recvdarray(int fd, output double[len] val, int len);
 */
const char* stubids6_ = "matsock_recvdarray(i int, o double[x], i int)";

void mexStub6(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    int         in0_;    /* fd         */
    int         in1_;    /* len        */
    double*     out0_=0; /* val        */
    int         dim2_;   /* len        */

    dim2_ = (int) mxWrapGetScalar(prhs[2], &mw_err_txt_);

    in0_ = (int) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    in1_ = (int) mxWrapGetScalar(prhs[1], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    out0_ = (double*) mxMalloc(dim2_*sizeof(double));
    if (mexprofrecord_)
        mexprofrecord_[6]++;
    matsock_recvdarray(in0_, out0_, in1_);
    plhs[0] = mxCreateDoubleMatrix(dim2_, 1, mxREAL);
    mxWrapCopy_double(plhs[0], out0_, dim2_);

mw_err_label:
    if (out0_) mxFree(out0_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- feapcsock.mw: 55 ----
 * matsock_recviarray(int fd, output int[len] val, int len);
 */
const char* stubids7_ = "matsock_recviarray(i int, o int[x], i int)";

void mexStub7(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    int         in0_;    /* fd         */
    int         in1_;    /* len        */
    int*        out0_=0; /* val        */
    int         dim2_;   /* len        */

    dim2_ = (int) mxWrapGetScalar(prhs[2], &mw_err_txt_);

    in0_ = (int) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    in1_ = (int) mxWrapGetScalar(prhs[1], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    out0_ = (int*) mxMalloc(dim2_*sizeof(int));
    if (mexprofrecord_)
        mexprofrecord_[7]++;
    matsock_recviarray(in0_, out0_, in1_);
    plhs[0] = mxCreateDoubleMatrix(dim2_, 1, mxREAL);
    mxWrapCopy_int(plhs[0], out0_, dim2_);

mw_err_label:
    if (out0_) mxFree(out0_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- feapcsock.mw: 60 ----
 * matsock_senddarray(int fd, double[] x, int len);
 */
const char* stubids8_ = "matsock_senddarray(i int, i double[], i int)";

void mexStub8(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    int         in0_;    /* fd         */
    double*     in1_ =0; /* x          */
    int         in2_;    /* len        */

    in0_ = (int) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    if (mxGetM(prhs[1])*mxGetN(prhs[1]) != 0) {
        in1_ = mxGetPr(prhs[1]);
    } else
        in1_ = NULL;
    in2_ = (int) mxWrapGetScalar(prhs[2], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    if (mexprofrecord_)
        mexprofrecord_[8]++;
    matsock_senddarray(in0_, in1_, in2_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- feapcsock.mw: 65 ----
 * matsock_sendiarray(int fd, int[] x, int len);
 */
const char* stubids9_ = "matsock_sendiarray(i int, i int[], i int)";

void mexStub9(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    int         in0_;    /* fd         */
    int*        in1_ =0; /* x          */
    int         in2_;    /* len        */

    in0_ = (int) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    if (mxGetM(prhs[1])*mxGetN(prhs[1]) != 0) {
        in1_ = mxWrapGetArray_int(prhs[1], &mw_err_txt_);
        if (mw_err_txt_)
            goto mw_err_label;
    } else
        in1_ = NULL;
    in2_ = (int) mxWrapGetScalar(prhs[2], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    if (mexprofrecord_)
        mexprofrecord_[9]++;
    matsock_sendiarray(in0_, in1_, in2_);

mw_err_label:
    if (in1_)  mxFree(in1_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- feapcsock.mw: 70 ----
 * cstring usrenv = getenv(cstring usrvar);
 */
const char* stubids10_ = "o cstring = getenv(i cstring)";

void mexStub10(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    char*       in0_ =0; /* usrvar     */

    in0_ = mxWrapGetString(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    if (mexprofrecord_)
        mexprofrecord_[10]++;
    plhs[0] = mxWrapStrncpy(getenv(in0_));

mw_err_label:
    if (in0_)  mxFree(in0_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ----
 */
void mexFunction(int nlhs, mxArray* plhs[],
                 int nrhs, const mxArray* prhs[])
{
    char id[512];
    if (nrhs == 0) {
        mexPrintf("Mex function installed\n");
        return;
    }

    if (mxGetString(prhs[0], id, sizeof(id)) != 0)
        mexErrMsgTxt("Identifier should be a string");
    else if (strcmp(id, stubids1_) == 0)
        mexStub1(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids2_) == 0)
        mexStub2(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids3_) == 0)
        mexStub3(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids4_) == 0)
        mexStub4(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids5_) == 0)
        mexStub5(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids6_) == 0)
        mexStub6(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids7_) == 0)
        mexStub7(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids8_) == 0)
        mexStub8(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids9_) == 0)
        mexStub9(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids10_) == 0)
        mexStub10(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, "*profile on*") == 0) {
        if (!mexprofrecord_) {
            mexprofrecord_ = (int*) malloc(11 * sizeof(int));
            mexLock();
        }
        memset(mexprofrecord_, 0, 11 * sizeof(int));
    } else if (strcmp(id, "*profile off*") == 0) {
        if (mexprofrecord_) {
            free(mexprofrecord_);
            mexUnlock();
        }
        mexprofrecord_ = NULL;
    } else if (strcmp(id, "*profile report*") == 0) {
        if (!mexprofrecord_)
            mexPrintf("Profiler inactive\n");
        mexPrintf("%d calls to feapcsock.mw:30\n", mexprofrecord_[1]);
        mexPrintf("%d calls to feapcsock.mw:32\n", mexprofrecord_[2]);
        mexPrintf("%d calls to feapcsock.mw:39\n", mexprofrecord_[3]);
        mexPrintf("%d calls to feapcsock.mw:43\n", mexprofrecord_[4]);
        mexPrintf("%d calls to feapcsock.mw:47\n", mexprofrecord_[5]);
        mexPrintf("%d calls to feapcsock.mw:51\n", mexprofrecord_[6]);
        mexPrintf("%d calls to feapcsock.mw:55\n", mexprofrecord_[7]);
        mexPrintf("%d calls to feapcsock.mw:60\n", mexprofrecord_[8]);
        mexPrintf("%d calls to feapcsock.mw:65\n", mexprofrecord_[9]);
        mexPrintf("%d calls to feapcsock.mw:70\n", mexprofrecord_[10]);
    } else if (strcmp(id, "*profile log*") == 0) {
        FILE* logfp;
        if (nrhs != 2 || mxGetString(prhs[1], id, sizeof(id)) != 0)
            mexErrMsgTxt("Must have two string arguments");
        logfp = fopen(id, "w+");
        if (!logfp)
            mexErrMsgTxt("Cannot open log for output");
        if (!mexprofrecord_)
            fprintf(logfp, "Profiler inactive\n");
        fprintf(logfp, "%d calls to feapcsock.mw:30\n", mexprofrecord_[1]);
        fprintf(logfp, "%d calls to feapcsock.mw:32\n", mexprofrecord_[2]);
        fprintf(logfp, "%d calls to feapcsock.mw:39\n", mexprofrecord_[3]);
        fprintf(logfp, "%d calls to feapcsock.mw:43\n", mexprofrecord_[4]);
        fprintf(logfp, "%d calls to feapcsock.mw:47\n", mexprofrecord_[5]);
        fprintf(logfp, "%d calls to feapcsock.mw:51\n", mexprofrecord_[6]);
        fprintf(logfp, "%d calls to feapcsock.mw:55\n", mexprofrecord_[7]);
        fprintf(logfp, "%d calls to feapcsock.mw:60\n", mexprofrecord_[8]);
        fprintf(logfp, "%d calls to feapcsock.mw:65\n", mexprofrecord_[9]);
        fprintf(logfp, "%d calls to feapcsock.mw:70\n", mexprofrecord_[10]);
        fclose(logfp);
    } else
        mexErrMsgTxt("Unknown identifier");
}

