#include <mex.h>
#include "assembler.cc"
#include "reassembler.cc"

void Assembler_add_batch(Assembler* aobj, int* ii, double* Aelt, 
                         int m1, int n1)
{
    for (int e = 0; e < n1; ++e)
        aobj->add_entries(ii+m1*e, ii+m1*e, Aelt+m1*m1*e, m1, m1, 1);
}

void Reassembler_add_batch(Reassembler* aobj, int* ii, double* Aelt, 
                           int m1, int n1)
{
    for (int e = 0; e < n1; ++e)
        aobj->add_entries(ii+m1*e, ii+m1*e, Aelt+m1*m1*e, m1, m1, 1);
}

mxArray* export_matrix(Assembler* matrix)
{
    int m = matrix->get_m();
    int n = matrix->get_n();
    int nnz = matrix->get_nnz();
    mxArray* result = mxCreateSparse(m, n, nnz, mxREAL);
    matrix->fill_csc(mxGetJc(result), mxGetIr(result), mxGetPr(result));
    return result;
}

mxArray* export_matrix_quick(Assembler* matrix)
{
    int m = matrix->get_m();
    int n = matrix->get_n();
    int nnz = matrix->get_pre_nnz();
    mxArray* result = mxCreateSparse(m, n, nnz, mxREAL);
    matrix->fill_csc(mxGetJc(result), mxGetIr(result), mxGetPr(result));
    return result;
}

mxArray* export_matrix(Reassembler* matrix)
{
    int m = matrix->get_m();
    int n = matrix->get_n();
    int nnz = matrix->get_nnz();
    mxArray* result = mxCreateSparse(m, n, nnz, mxREAL);
    matrix->fill_csc(mxGetJc(result), mxGetIr(result), mxGetPr(result));
    return result;
}

template <class intT>
void pack_matrixT(intT* jc, intT* ir, double* pr, int n, double tol)
{
    intT*   ir_out = ir;
    double* pr_out = pr;
    int nnz = 0;
    for (int j = 0; j < n; ++j) {
        int ii_start = jc[j];
        int ii_end   = jc[j+1];
        jc[j] = nnz;
        for (int ii = ii_start; ii < ii_end; ++ii, ++pr, ++ir) {
            if (*pr < -tol || *pr > tol) {
                *pr_out++ = *pr;
                *ir_out++ = *ir;
                ++nnz;
            }
        }
    }
    jc[n] = nnz;
}

mxArray* pack_matrix(const mxArray* A0, double tol)
{
    mxArray* A = mxDuplicateArray(A0);
    if (mxIsSparse(A))
        pack_matrixT(mxGetJc(A), mxGetIr(A), mxGetPr(A), mxGetN(A), tol);
    return A;
}
Reassembler* new_reassembler(const mxArray* A0)
{
    return new Reassembler(mxGetJc(A0), mxGetIr(A0), mxGetM(A0), mxGetN(A0));
}
/* --------------------------------------------------- */
/* Automatically generated by mwrap                    */
/* --------------------------------------------------- */

/* Code generated by mwrap */
/*
  Copyright statement for mwrap:

  mwrap -- MEX file generation for MATLAB and Octave
  Copyright (c) 2007-2008 David Bindel

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  You may distribute a work that contains part or all of the source code
  generated by mwrap under the terms of your choice.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/

#include <mex.h>
#include <stdio.h>
#include <string.h>


#ifndef ulong
#  define ulong unsigned long
#endif
#ifndef uint
#  define uint  unsigned int
#endif
#ifndef uchar
#  define uchar unsigned char
#endif


/*
 * Records for call profile.
 */
int* mexprofrecord_= NULL;


/*
 * Support routines for copying data into and out of the MEX stubs
 */

void* mxWrapGetP(const mxArray* a, const char* fmt, const char** e)
{
    void* p = 0;
    mxArray* ap;
    if (mxGetClassID(a) == mxDOUBLE_CLASS && 
        mxGetM(a)*mxGetN(a) == 1 && *mxGetPr(a) == 0)
        return p;
    if (mxIsChar(a)) {
        char pbuf[128];
        mxGetString(a, pbuf, sizeof(pbuf));
        sscanf(pbuf, fmt, &p);
    } 
#ifdef R2008OO
    else if (ap = mxGetProperty(a, 0, "mwptr")) {
        return mxWrapGetP(ap, fmt, e);
    }
#endif
    if (p == 0)
        *e = "Invalid pointer";
    return p;
}

mxArray* mxWrapCreateP(void* p, const char* fmt)
{
    if (p == 0) {
        mxArray* z = mxCreateDoubleMatrix(1,1, mxREAL);
        *mxGetPr(z) = 0;
        return z;
    } else {
        char pbuf[128];
        sprintf(pbuf, fmt, p);
        return mxCreateString(pbuf);
    }
}

mxArray* mxWrapStrncpy(const char* s)
{
    if (s) {
        return mxCreateString(s);
    } else {
        mxArray* z = mxCreateDoubleMatrix(1,1, mxREAL);
        *mxGetPr(z) = 0;
        return z;
    }
}

double mxWrapGetScalar(const mxArray* a, const char** e)
{
    if (!a || mxGetClassID(a) != mxDOUBLE_CLASS || mxGetM(a)*mxGetN(a) != 1) {
        *e = "Invalid scalar argument";
        return 0;
    }
    return *mxGetPr(a);
}

char* mxWrapGetString(const mxArray* a, const char** e)
{
    char* s;
    int slen;
    if (!a || (!mxIsChar(a) && mxGetM(a)*mxGetN(a) > 0)) {
        *e = "Invalid string argument";
        return NULL;
    }
    slen = mxGetM(a)*mxGetN(a) + 1;
    s = (char*) mxMalloc(slen);
    if (mxGetM(a)*mxGetN(a) == 0)
        *s = 0;
    else
        mxGetString(a, s, slen);
    return s;
}


#define mxWrapGetArrayDef(func, T) \
T* func(const mxArray* a, const char** e)     \
{ \
    T* array; \
    int arraylen; \
    int i; \
    T* p; \
    double* q; \
    if (!a || mxGetClassID(a) != mxDOUBLE_CLASS) { \
        *e = "Invalid array argument"; \
        return 0; \
    } \
    arraylen = mxGetM(a)*mxGetN(a); \
    array = (T*) mxMalloc(mxGetM(a)*mxGetN(a) * sizeof(T)); \
    p = array; \
    q = mxGetPr(a); \
    for (i = 0; i < arraylen; ++i) \
        *p++ = (T) (*q++); \
    return array; \
}


#define mxWrapCopyDef(func, T) \
void func(mxArray* a, const T* q, int n) \
{ \
    int i; \
    double* p = mxGetPr(a); \
    for (i = 0; i < n; ++i) \
        *p++ = *q++; \
}


#define mxWrapReturnDef(func, T) \
mxArray* func(const T* q, int m, int n) \
{ \
    int i; \
    double* p; \
    if (!q) { \
        return mxCreateDoubleMatrix(0,0, mxREAL); \
    } else { \
        mxArray* a = mxCreateDoubleMatrix(m,n, mxREAL); \
        p = mxGetPr(a); \
        for (i = 0; i < m*n; ++i) \
            *p++ = *q++; \
        return a; \
    } \
}


#define mxWrapGetScalarZDef(func, T, ZT, setz) \
void func(T* z, const mxArray* a) \
{ \
    double* pr = mxGetPr(a); \
    double* pi = mxGetPi(a); \
    setz(z, (ZT) *pr, (pi ? (ZT) *pi : (ZT) 0)); \
}


#define mxWrapGetArrayZDef(func, T, ZT, setz) \
T* func(const mxArray* a, const char** e) \
{ \
    T* array; \
    int arraylen; \
    int i; \
    T* p; \
    double* qr; \
    double* qi; \
    if (!a || mxGetClassID(a) != mxDOUBLE_CLASS) { \
        *e = "Invalid array argument"; \
        return 0; \
    } \
    arraylen = mxGetM(a)*mxGetN(a); \
    array = (T*) mxMalloc(mxGetM(a)*mxGetN(a) * sizeof(T)); \
    p = array; \
    qr = mxGetPr(a); \
    qi = mxGetPi(a); \
    for (i = 0; i < arraylen; ++i) { \
        ZT val_qr = *qr++; \
        ZT val_qi = (qi ? (ZT) *qi++ : (ZT) 0); \
        setz(p, val_qr, val_qi); \
        ++p; \
    } \
    return array; \
}


#define mxWrapCopyZDef(func, T, real, imag) \
void func(mxArray* a, const T* q, int n) \
{ \
    int i; \
    double* pr = mxGetPr(a); \
    double* pi = mxGetPi(a); \
    for (i = 0; i < n; ++i) { \
        *pr++ = real(*q); \
        *pi++ = imag(*q); \
        ++q; \
    } \
}


#define mxWrapReturnZDef(func, T, real, imag) \
mxArray* func(const T* q, int m, int n) \
{ \
    int i; \
    double* pr; \
    double* pi; \
    if (!q) { \
        return mxCreateDoubleMatrix(0,0, mxCOMPLEX); \
    } else { \
        mxArray* a = mxCreateDoubleMatrix(m,n, mxCOMPLEX); \
        pr = mxGetPr(a); \
        pi = mxGetPi(a); \
        for (i = 0; i < m*n; ++i) { \
            *pr++ = real(*q); \
            *pi++ = imag(*q); \
            ++q; \
        } \
        return a; \
    } \
}

/* Array copier definitions */
mxWrapGetArrayDef(mxWrapGetArray_bool, bool)
mxWrapCopyDef    (mxWrapCopy_bool,     bool)
mxWrapReturnDef  (mxWrapReturn_bool,   bool)
mxWrapGetArrayDef(mxWrapGetArray_char, char)
mxWrapCopyDef    (mxWrapCopy_char,     char)
mxWrapReturnDef  (mxWrapReturn_char,   char)
mxWrapGetArrayDef(mxWrapGetArray_double, double)
mxWrapCopyDef    (mxWrapCopy_double,     double)
mxWrapReturnDef  (mxWrapReturn_double,   double)
mxWrapGetArrayDef(mxWrapGetArray_float, float)
mxWrapCopyDef    (mxWrapCopy_float,     float)
mxWrapReturnDef  (mxWrapReturn_float,   float)
mxWrapGetArrayDef(mxWrapGetArray_int, int)
mxWrapCopyDef    (mxWrapCopy_int,     int)
mxWrapReturnDef  (mxWrapReturn_int,   int)
mxWrapGetArrayDef(mxWrapGetArray_long, long)
mxWrapCopyDef    (mxWrapCopy_long,     long)
mxWrapReturnDef  (mxWrapReturn_long,   long)
mxWrapGetArrayDef(mxWrapGetArray_size_t, size_t)
mxWrapCopyDef    (mxWrapCopy_size_t,     size_t)
mxWrapReturnDef  (mxWrapReturn_size_t,   size_t)
mxWrapGetArrayDef(mxWrapGetArray_uchar, uchar)
mxWrapCopyDef    (mxWrapCopy_uchar,     uchar)
mxWrapReturnDef  (mxWrapReturn_uchar,   uchar)
mxWrapGetArrayDef(mxWrapGetArray_uint, uint)
mxWrapCopyDef    (mxWrapCopy_uint,     uint)
mxWrapReturnDef  (mxWrapReturn_uint,   uint)
mxWrapGetArrayDef(mxWrapGetArray_ulong, ulong)
mxWrapCopyDef    (mxWrapCopy_ulong,     ulong)
mxWrapReturnDef  (mxWrapReturn_ulong,   ulong)

/* ---- assembler.mw: 124 ----
 * Assembler* aobj = new(int m, int n, bool include_zeros);
 */
const char* stubids1_ = "o Assembler* = new(i int, i int, i bool)";

void mexStub1(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    int         in0_;    /* m          */
    int         in1_;    /* n          */
    bool        in2_;    /* include_zeros */
    Assembler*  out0_=0; /* aobj       */

    in0_ = (int) mxWrapGetScalar(prhs[0], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    in1_ = (int) mxWrapGetScalar(prhs[1], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    in2_ = (bool) mxWrapGetScalar(prhs[2], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    if (mexprofrecord_)
        mexprofrecord_[1]++;
    out0_ = new Assembler(in0_, in1_, in2_);
    plhs[0] = mxWrapCreateP(out0_, "Assembler:%p");

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- assembler.mw: 131 ----
 * delete(Assembler* aobj);
 */
const char* stubids2_ = "delete(i Assembler*)";

void mexStub2(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Assembler*  in0_ =0; /* aobj       */

    in0_ = (Assembler*) mxWrapGetP(prhs[0], "Assembler:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    if (mexprofrecord_)
        mexprofrecord_[2]++;
    delete(in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- assembler.mw: 139 ----
 * aobj->Assembler.add_entries(int[m] ii, int[n] jj, double[m, n] Aelt, int m, int n, int 1);
 */
const char* stubids3_ = "aobj->Assembler.add_entries(i int[x], i int[x], i double[xx], i int, i int, i int)";

void mexStub3(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Assembler*  in0_ =0; /* aobj       */
    int*        in1_ =0; /* ii         */
    int*        in2_ =0; /* jj         */
    double*     in3_ =0; /* Aelt       */
    int         in4_;    /* m          */
    int         in5_;    /* n          */
    int         in6_;    /* 1          */
    int         dim7_;   /* m          */
    int         dim8_;   /* n          */
    int         dim9_;   /* m          */
    int         dim10_;   /* n          */

    dim7_ = (int) mxWrapGetScalar(prhs[7], &mw_err_txt_);
    dim8_ = (int) mxWrapGetScalar(prhs[8], &mw_err_txt_);
    dim9_ = (int) mxWrapGetScalar(prhs[9], &mw_err_txt_);
    dim10_ = (int) mxWrapGetScalar(prhs[10], &mw_err_txt_);

    if (mxGetM(prhs[1])*mxGetN(prhs[1]) != dim7_) {
        mw_err_txt_ = "Bad argument size: ii";        goto mw_err_label;
    }

    if (mxGetM(prhs[2])*mxGetN(prhs[2]) != dim8_) {
        mw_err_txt_ = "Bad argument size: jj";        goto mw_err_label;
    }

    if (mxGetM(prhs[3]) != dim9_ ||
        mxGetN(prhs[3]) != dim10_) {
        mw_err_txt_ = "Bad argument size: Aelt";
        goto mw_err_label;
    }

    in0_ = (Assembler*) mxWrapGetP(prhs[0], "Assembler:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    if (mxGetM(prhs[1])*mxGetN(prhs[1]) != 0) {
        in1_ = mxWrapGetArray_int(prhs[1], &mw_err_txt_);
        if (mw_err_txt_)
            goto mw_err_label;
    } else
        in1_ = NULL;
    if (mxGetM(prhs[2])*mxGetN(prhs[2]) != 0) {
        in2_ = mxWrapGetArray_int(prhs[2], &mw_err_txt_);
        if (mw_err_txt_)
            goto mw_err_label;
    } else
        in2_ = NULL;
    if (mxGetM(prhs[3])*mxGetN(prhs[3]) != 0) {
        in3_ = mxGetPr(prhs[3]);
    } else
        in3_ = NULL;
    in4_ = (int) mxWrapGetScalar(prhs[4], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    in5_ = (int) mxWrapGetScalar(prhs[5], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    in6_ = (int) mxWrapGetScalar(prhs[6], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    if (mexprofrecord_)
        mexprofrecord_[3]++;
    if (!in0_) {
        mw_err_txt_ = "Cannot dispatch to NULL";
        goto mw_err_label;
    }
    in0_->add_entries(in1_, in2_, in3_, in4_, in5_, in6_);

mw_err_label:
    if (in1_)  mxFree(in1_);
    if (in2_)  mxFree(in2_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- assembler.mw: 149 ----
 * Assembler_add_batch(Assembler* aobj, int[] ii, double[] Aelt, int m1, int n1);
 */
const char* stubids4_ = "Assembler_add_batch(i Assembler*, i int[], i double[], i int, i int)";

void mexStub4(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Assembler*  in0_ =0; /* aobj       */
    int*        in1_ =0; /* ii         */
    double*     in2_ =0; /* Aelt       */
    int         in3_;    /* m1         */
    int         in4_;    /* n1         */

    in0_ = (Assembler*) mxWrapGetP(prhs[0], "Assembler:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    if (mxGetM(prhs[1])*mxGetN(prhs[1]) != 0) {
        in1_ = mxWrapGetArray_int(prhs[1], &mw_err_txt_);
        if (mw_err_txt_)
            goto mw_err_label;
    } else
        in1_ = NULL;
    if (mxGetM(prhs[2])*mxGetN(prhs[2]) != 0) {
        in2_ = mxGetPr(prhs[2]);
    } else
        in2_ = NULL;
    in3_ = (int) mxWrapGetScalar(prhs[3], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    in4_ = (int) mxWrapGetScalar(prhs[4], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    if (mexprofrecord_)
        mexprofrecord_[4]++;
    Assembler_add_batch(in0_, in1_, in2_, in3_, in4_);

mw_err_label:
    if (in1_)  mxFree(in1_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- assembler.mw: 157 ----
 * mxArray K = export_matrix(Assembler* aobj);
 */
const char* stubids5_ = "o mxArray = export_matrix(i Assembler*)";

void mexStub5(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Assembler*  in0_ =0; /* aobj       */

    in0_ = (Assembler*) mxWrapGetP(prhs[0], "Assembler:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    if (mexprofrecord_)
        mexprofrecord_[5]++;
    plhs[0] = export_matrix(in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- assembler.mw: 164 ----
 * mxArray K = export_matrix_quick(Assembler* aobj);
 */
const char* stubids6_ = "o mxArray = export_matrix_quick(i Assembler*)";

void mexStub6(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Assembler*  in0_ =0; /* aobj       */

    in0_ = (Assembler*) mxWrapGetP(prhs[0], "Assembler:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    if (mexprofrecord_)
        mexprofrecord_[6]++;
    plhs[0] = export_matrix_quick(in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- assembler.mw: 177 ----
 * Reassembler* aobj = new_reassembler(mxArray A0);
 */
const char* stubids7_ = "o Reassembler* = new_reassembler(i mxArray)";

void mexStub7(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    const mxArray*  in0_;    /* A0         */
    Reassembler*  out0_=0; /* aobj       */

    in0_ = prhs[0];
    if (mexprofrecord_)
        mexprofrecord_[7]++;
    out0_ = new_reassembler(in0_);
    plhs[0] = mxWrapCreateP(out0_, "Reassembler:%p");

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- assembler.mw: 184 ----
 * delete(Reassembler* aobj);
 */
const char* stubids8_ = "delete(i Reassembler*)";

void mexStub8(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Reassembler*  in0_ =0; /* aobj       */

    in0_ = (Reassembler*) mxWrapGetP(prhs[0], "Reassembler:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    if (mexprofrecord_)
        mexprofrecord_[8]++;
    delete(in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- assembler.mw: 192 ----
 * aobj->Reassembler.add_entries(int[m] ii, int[n] jj, double[m, n] Aelt, int m, int n, int 1);
 */
const char* stubids9_ = "aobj->Reassembler.add_entries(i int[x], i int[x], i double[xx], i int, i int, i int)";

void mexStub9(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Reassembler*  in0_ =0; /* aobj       */
    int*        in1_ =0; /* ii         */
    int*        in2_ =0; /* jj         */
    double*     in3_ =0; /* Aelt       */
    int         in4_;    /* m          */
    int         in5_;    /* n          */
    int         in6_;    /* 1          */
    int         dim7_;   /* m          */
    int         dim8_;   /* n          */
    int         dim9_;   /* m          */
    int         dim10_;   /* n          */

    dim7_ = (int) mxWrapGetScalar(prhs[7], &mw_err_txt_);
    dim8_ = (int) mxWrapGetScalar(prhs[8], &mw_err_txt_);
    dim9_ = (int) mxWrapGetScalar(prhs[9], &mw_err_txt_);
    dim10_ = (int) mxWrapGetScalar(prhs[10], &mw_err_txt_);

    if (mxGetM(prhs[1])*mxGetN(prhs[1]) != dim7_) {
        mw_err_txt_ = "Bad argument size: ii";        goto mw_err_label;
    }

    if (mxGetM(prhs[2])*mxGetN(prhs[2]) != dim8_) {
        mw_err_txt_ = "Bad argument size: jj";        goto mw_err_label;
    }

    if (mxGetM(prhs[3]) != dim9_ ||
        mxGetN(prhs[3]) != dim10_) {
        mw_err_txt_ = "Bad argument size: Aelt";
        goto mw_err_label;
    }

    in0_ = (Reassembler*) mxWrapGetP(prhs[0], "Reassembler:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    if (mxGetM(prhs[1])*mxGetN(prhs[1]) != 0) {
        in1_ = mxWrapGetArray_int(prhs[1], &mw_err_txt_);
        if (mw_err_txt_)
            goto mw_err_label;
    } else
        in1_ = NULL;
    if (mxGetM(prhs[2])*mxGetN(prhs[2]) != 0) {
        in2_ = mxWrapGetArray_int(prhs[2], &mw_err_txt_);
        if (mw_err_txt_)
            goto mw_err_label;
    } else
        in2_ = NULL;
    if (mxGetM(prhs[3])*mxGetN(prhs[3]) != 0) {
        in3_ = mxGetPr(prhs[3]);
    } else
        in3_ = NULL;
    in4_ = (int) mxWrapGetScalar(prhs[4], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    in5_ = (int) mxWrapGetScalar(prhs[5], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    in6_ = (int) mxWrapGetScalar(prhs[6], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    if (mexprofrecord_)
        mexprofrecord_[9]++;
    if (!in0_) {
        mw_err_txt_ = "Cannot dispatch to NULL";
        goto mw_err_label;
    }
    in0_->add_entries(in1_, in2_, in3_, in4_, in5_, in6_);

mw_err_label:
    if (in1_)  mxFree(in1_);
    if (in2_)  mxFree(in2_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- assembler.mw: 202 ----
 * Reassembler_add_batch(Reassembler* aobj, int[] ii, double[] Aelt, int m1, int n1);
 */
const char* stubids10_ = "Reassembler_add_batch(i Reassembler*, i int[], i double[], i int, i int)";

void mexStub10(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Reassembler*  in0_ =0; /* aobj       */
    int*        in1_ =0; /* ii         */
    double*     in2_ =0; /* Aelt       */
    int         in3_;    /* m1         */
    int         in4_;    /* n1         */

    in0_ = (Reassembler*) mxWrapGetP(prhs[0], "Reassembler:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    if (mxGetM(prhs[1])*mxGetN(prhs[1]) != 0) {
        in1_ = mxWrapGetArray_int(prhs[1], &mw_err_txt_);
        if (mw_err_txt_)
            goto mw_err_label;
    } else
        in1_ = NULL;
    if (mxGetM(prhs[2])*mxGetN(prhs[2]) != 0) {
        in2_ = mxGetPr(prhs[2]);
    } else
        in2_ = NULL;
    in3_ = (int) mxWrapGetScalar(prhs[3], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    in4_ = (int) mxWrapGetScalar(prhs[4], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    if (mexprofrecord_)
        mexprofrecord_[10]++;
    Reassembler_add_batch(in0_, in1_, in2_, in3_, in4_);

mw_err_label:
    if (in1_)  mxFree(in1_);
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- assembler.mw: 210 ----
 * mxArray K = export_matrix(Reassembler* aobj);
 */
const char* stubids11_ = "o mxArray = export_matrix(i Reassembler*)";

void mexStub11(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    Reassembler*  in0_ =0; /* aobj       */

    in0_ = (Reassembler*) mxWrapGetP(prhs[0], "Reassembler:%p", &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    if (mexprofrecord_)
        mexprofrecord_[11]++;
    plhs[0] = export_matrix(in0_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ---- assembler.mw: 218 ----
 * mxArray A = pack_matrix(mxArray A0, double tol);
 */
const char* stubids12_ = "o mxArray = pack_matrix(i mxArray, i double)";

void mexStub12(int nlhs, mxArray* plhs[],
              int nrhs, const mxArray* prhs[])
{
    const char* mw_err_txt_ = 0;
    const mxArray*  in0_;    /* A0         */
    double      in1_;    /* tol        */

    in0_ = prhs[0];
    in1_ = (double) mxWrapGetScalar(prhs[1], &mw_err_txt_);
    if (mw_err_txt_)
        goto mw_err_label;
    if (mexprofrecord_)
        mexprofrecord_[12]++;
    plhs[0] = pack_matrix(in0_, in1_);

mw_err_label:
    if (mw_err_txt_)
        mexErrMsgTxt(mw_err_txt_);
}

/* ----
 */
void mexFunction(int nlhs, mxArray* plhs[],
                 int nrhs, const mxArray* prhs[])
{
    char id[512];
    if (nrhs == 0) {
        mexPrintf("Mex function installed\n");
        return;
    }

    if (mxGetString(prhs[0], id, sizeof(id)) != 0)
        mexErrMsgTxt("Identifier should be a string");
    else if (strcmp(id, stubids1_) == 0)
        mexStub1(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids2_) == 0)
        mexStub2(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids3_) == 0)
        mexStub3(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids4_) == 0)
        mexStub4(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids5_) == 0)
        mexStub5(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids6_) == 0)
        mexStub6(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids7_) == 0)
        mexStub7(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids8_) == 0)
        mexStub8(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids9_) == 0)
        mexStub9(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids10_) == 0)
        mexStub10(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids11_) == 0)
        mexStub11(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, stubids12_) == 0)
        mexStub12(nlhs,plhs, nrhs-1,prhs+1);
    else if (strcmp(id, "*profile on*") == 0) {
        if (!mexprofrecord_) {
            mexprofrecord_ = (int*) malloc(13 * sizeof(int));
            mexLock();
        }
        memset(mexprofrecord_, 0, 13 * sizeof(int));
    } else if (strcmp(id, "*profile off*") == 0) {
        if (mexprofrecord_) {
            free(mexprofrecord_);
            mexUnlock();
        }
        mexprofrecord_ = NULL;
    } else if (strcmp(id, "*profile report*") == 0) {
        if (!mexprofrecord_)
            mexPrintf("Profiler inactive\n");
        mexPrintf("%d calls to assembler.mw:124\n", mexprofrecord_[1]);
        mexPrintf("%d calls to assembler.mw:131\n", mexprofrecord_[2]);
        mexPrintf("%d calls to assembler.mw:139\n", mexprofrecord_[3]);
        mexPrintf("%d calls to assembler.mw:149\n", mexprofrecord_[4]);
        mexPrintf("%d calls to assembler.mw:157\n", mexprofrecord_[5]);
        mexPrintf("%d calls to assembler.mw:164\n", mexprofrecord_[6]);
        mexPrintf("%d calls to assembler.mw:177\n", mexprofrecord_[7]);
        mexPrintf("%d calls to assembler.mw:184\n", mexprofrecord_[8]);
        mexPrintf("%d calls to assembler.mw:192\n", mexprofrecord_[9]);
        mexPrintf("%d calls to assembler.mw:202\n", mexprofrecord_[10]);
        mexPrintf("%d calls to assembler.mw:210\n", mexprofrecord_[11]);
        mexPrintf("%d calls to assembler.mw:218\n", mexprofrecord_[12]);
    } else if (strcmp(id, "*profile log*") == 0) {
        FILE* logfp;
        if (nrhs != 2 || mxGetString(prhs[1], id, sizeof(id)) != 0)
            mexErrMsgTxt("Must have two string arguments");
        logfp = fopen(id, "w+");
        if (!logfp)
            mexErrMsgTxt("Cannot open log for output");
        if (!mexprofrecord_)
            fprintf(logfp, "Profiler inactive\n");
        fprintf(logfp, "%d calls to assembler.mw:124\n", mexprofrecord_[1]);
        fprintf(logfp, "%d calls to assembler.mw:131\n", mexprofrecord_[2]);
        fprintf(logfp, "%d calls to assembler.mw:139\n", mexprofrecord_[3]);
        fprintf(logfp, "%d calls to assembler.mw:149\n", mexprofrecord_[4]);
        fprintf(logfp, "%d calls to assembler.mw:157\n", mexprofrecord_[5]);
        fprintf(logfp, "%d calls to assembler.mw:164\n", mexprofrecord_[6]);
        fprintf(logfp, "%d calls to assembler.mw:177\n", mexprofrecord_[7]);
        fprintf(logfp, "%d calls to assembler.mw:184\n", mexprofrecord_[8]);
        fprintf(logfp, "%d calls to assembler.mw:192\n", mexprofrecord_[9]);
        fprintf(logfp, "%d calls to assembler.mw:202\n", mexprofrecord_[10]);
        fprintf(logfp, "%d calls to assembler.mw:210\n", mexprofrecord_[11]);
        fprintf(logfp, "%d calls to assembler.mw:218\n", mexprofrecord_[12]);
        fclose(logfp);
    } else
        mexErrMsgTxt("Unknown identifier");
}

