#!/bin/bash

if [[ ! ("$#" == 1) ]]; then
    echo ""
    echo ""
    echo  'Usage: sample_scrpit.sh  C-parameter'
    echo ""
    echo "This script runs SVM^{sle}cutables for a 10 iterations"
    echo "on U.S. Congressional Floor Debates data."
    echo ''
    echo ''
    exit 1
fi   


rm -rf  _latent _models _results
mkdir _latent
mkdir _models
mkdir _results

c=$1

echo $c
e=0.001
 
 
 ./bin/svm_sle_learn  -c $c  -e $e   ./speaker-based/training_set.txt  hiddenvars_OpinionFinder.txt  ./_models/model.c.$c.e.$e
     
 ./bin/svm_sle_classify -l ./speaker-based/training_set.txt   ./_models/model.c.$c.e.$e  ./_latent/hiddenvars.c.$c.e.$e.iter.1
    
 ./bin/svm_sle_classify  ./speaker-based/test_set.txt   ./_models/model.c.$c.e.$e   > ./_results/results.test.c.$c.e.$e.full.txt
 grep "Zero/one" ./_results/results.test.c.$c.e.$e.full.txt | cut -d' ' -f5 | tr -d % >> ./_results/results.test.c.$c.e.$e.iter.0.txt
 
 ./bin/svm_sle_classify  ./speaker-based/development_set.txt  ./_models/model.c.$c.e.$e   > ./_results/results.valid.c.$c.e.$e.full.txt
 grep "Zero/one" ./_results/results.valid.c.$c.e.$e.full.txt | cut -d' ' -f5 | tr -d % >> ./_results/results.valid.c.$c.e.$e.iter.0.txt

 for iter in 1 2 3 4 5 6 7 8 9 
  do
     ./bin/svm_sle_learn  -c $c  -e $e    ./speaker-based/training_set.txt  ./_latent/hiddenvars.c.$c.e.$e.iter.$iter  ./_models/model.c.$c.e.$e
     
    ./bin/svm_sle_classify -l ./speaker-based/training_set.txt   ./_models/model.c.$c.e.$e  ./_latent/hiddenvars.c.$c.e.$e.iter.$((iter+1))
    
    ./bin/svm_sle_classify  ./speaker-based/test_set.txt   ./_models/model.c.$c.e.$e   > ./_results/results.test.c.$c.e.$e.full.txt
    grep "Zero/one" ./_results/results.test.c.$c.e.$e.full.txt | cut -d' ' -f5 | tr -d % >> ./_results/results.test.c.$c.e.$e.iter.$iter.txt
 
    ./bin/svm_sle_classify  ./speaker-based/development_set.txt  ./_models/model.c.$c.e.$e   > ./_results/results.valid.c.$c.e.$e.full.txt
     grep "Zero/one" ./_results/results.valid.c.$c.e.$e.full.txt | cut -d' ' -f5  | tr -d % >> ./_results/results.valid.c.$c.e.$e.iter.$iter.txt

  done
  
    



