/*
 * Nest simulation library - simulation time advance routine
 */

#include "nest.h"

#include "defs.h"
#include "simulate.h"
#include "process.h"
#include "graph.h"

/*
 * Advance simulation time on a node where time has stopped.
 */

void
advance (addtime)
timev           addtime;
{
    timev           time_temp;

    time_temp = _proc_table[_current_node].runtime;

    time_add (time_temp, addtime);      /* convert sleep time to wakeup time */

    if (_block (time_temp, ADVANCE))
        fatal ("advance: block: ");
}

void
abs_advance (abs_time)
	timev abs_time;
{
	timev time_temp;

	time_temp = _proc_table[_current_node].runtime;
	if (time_after(time_temp, abs_time))
		/* Cannot advance to an earlier time. */
		return;
	if (_block(abs_time, ADVANCE))
		fatal ("advance: block: ");
}

/*
 * Return true if any messages waiting in queue
 */

any_messages ()
{
    timev          *result;


    if (not (result =                   /* no msgs before current moment */
             _check_queue (_current_node, &time_zero,
                           &_proc_table[_current_node].runtime)))
    {                                   /* block until present time */
        if (_block (_proc_table[_current_node].runtime, RECEIVE))
            fatal ("any_messages: block: ");
        result = _check_queue (_current_node, &time_zero,
                               &_proc_table[_current_node].runtime);
    }                                   /* and check again */

    return (result isnt nil);
}

/*
 * Return the runtime of the current node
 */

timev           runtime ()
{
    timev           time_now;

    time_now = _proc_table[_current_node].runtime;
    return (time_normalize(time_now));
}

/*
 * Return a node list of all neighbors
 */

node_ptr        get_neighbors (nodeid)
ident           nodeid;
{
    node_ptr        _get_nbrs ();

    return _get_nbrs (nodeid ? nodeid : _current_node);

}
