/*
 * Nest simulation library - process stack memory management definitions
 * 
 * $Header: swap.h,v 2.5 88/03/31 14:50:44 dupuy Rel $
 */

/*
 * The swap table and swap queues are used to maintain the stacks for the
 * nodes in a simulation.  Since there may be many nodes, some of whose stacks
 * may get quite large, and since they will be constantly allocated and
 * deallocated, we use a special storage area, and maintain an swap queue
 * which allows us to collapse adjacent free blocks whenever a block is
 * deallocated, and which permits efficient compaction when necessary.
 * 
 * A swap queue is a doubly linked queue as defined below; The two lists
 * (freelist and swaplist) have forward pointers to their own next members,
 * and backward pointers to the swap_elem of the other kind which has space at
 * the immediately lower address.
 */

typedef struct swap_struct *swap_ptr;

typedef struct swap_struct
{
    swap_ptr        next;               /* next swap_elem of same class */
    swap_ptr        back;               /* adjacent swap_elem at lower addr */

    char           *blockhead;          /* ptr to start of the storage space */
    unsigned        size;               /* size of the storage space */
} swap_elem;

/*
 * The free space swap_elems are dynamically allocated, while the allocated
 * space swap_elems are entries in the swaptable.  Free space swap elems also
 * have blockheads which actually point at the last (highest) address in the
 * block, while allocated space swap_elems point at the start of the block.
 */

/*
 * The `swaptable', which keeps track of the allocated swap space for the
 * nodes, is simply an array (indexed by node id's) of swap_elems, which will
 * be on the swaplist if they are allocated.  The zero'th entry is used as a
 * header which make the queue circular; its forward pointer is to the first
 * node with allocated space, its backward pointer is to the last free block.
 */

static swap_ptr swaptable;              /* size of `nodes' arg to simulate() */

static unsigned stacksize;              /* size of stack storage area */

#define swaplist swaptable[0].next      /* swaptable[0] is header node */

#define freelist swaptable[0].back      /* swaplist and freelist form a ring */

#define baseptr swaptable[0].blockhead  /* pointer to base of storage area */

#ifndef debug
#define dumptable()
#endif
