/*
 * Nest simulation library - process stack storage routines
 * 
 * $Header: store.c,v 1.2 90/10/19 16:32:57 mccanne Exp $
 */ 

#include "nest.h"

#include "defs.h"
#include "simulate.h"

/*
 * This function destroys a block on the storage heap.
 */

nest_destroy (nodeid)
ident           nodeid;                 /* id of node to restore */
{
    extern char    *_deallocate ();

    char           *fromptr;            /* pointer to block */
    unsigned        size;               /* size of contents */

    fromptr =                           /* deallocate space for node */
        _deallocate (nodeid, &size);

    if (fromptr is nil)
        return (_error ("corrupted stack storage"));

    return (None);
}


/*
 * This function restores a block on the storage heap back onto the stack.
 */

nest_restore (nodeid)
ident           nodeid;                 /* id of node to restore */
{
    extern char    *_deallocate ();

    char           *fromptr;            /* pointer to block */
    unsigned        size;               /* size of contents */

    fromptr =                           /* deallocate space for node */
        _deallocate (nodeid, &size);

    if (fromptr is nil)
        return (_error ("corrupted stack storage"));

#if STACKDIR < 0                        /* stack runs to lower addresses */
    bcopy (fromptr, _stackbase - size, (int) size);
#else
    bcopy (fromptr, _stackbase, (int) size);
#endif
    return (None);
}



/*
 * This function stores the contents of stack onto the heap, where a suitable
 * memory slot is allocated by calling _allocate().
 */

/* ARGSUSED */
nest_store (stack, onstack)
char           *stack;                  /* pointer to stack */
int             onstack;                /* unused `on signal stack' flag */
{
    extern char    *_allocate ();

    char           *toptr;              /* pointer to block */
    int             size;               /* size of the stack */

    size = STACKDIR * (stack - _stackbase);

    if (size < 0)
#if STACKDIR < 0
        return (_error ("stack reversed (try #define STACKDIR 1)"));
#else
        return (_error ("stack reversed (try #define STACKDIR -1)"));
#endif

    toptr =                             /* allocate space for currentnode */
        _allocate (_current_node, (unsigned) size);

    if (toptr is nil)
        return (_error ("insufficient stack storage: %s"));
#ifdef sparc
     flush_windows();
#endif

#if STACKDIR < 1
    bcopy (stack, toptr, size);         /* copy contents over */
#else
    bcopy (_stackbase, toptr, size);
#endif
    return (None);
}
