/* code by S. McCanne at LBL */

	.text
	.globl	_nest_stack
_nest_stack:
	retl
	mov	%sp, %o0		/* return sp */

	.globl	_nest_xstack
_nest_xstack:
	add	%o0, -64, %o0		/* room for kernel save area */
	retl
	and	%o0, 0xfffffff8, %sp	/* multiple of 8 bytes */

	.globl	_nest_freeze
_nest_freeze:
	st	%sp, [%o0]		/* caller's sp, becomes _cook's fp */
	st	%o7, [%o0+4]		/* return address */
	retl
	mov	%g0, %o0		/* return 0 */

	.globl	_nest_cook
_nest_cook:
/*  First, flush the windows.  All we really want to do is make all
    the windows except the current one invalid, but I don't know how to
    do this.  (This assumes the new stack does not overlap with the
    current one.)
    We then load the new stack pointer, making sure there is room
    for the kernel if an interrupt occurs before the restore.
    Finally, we jump to the return address, and restore to the
    new stack's  window.  Since the windows have been flushed,
    an underflow trap will occur, and the frame will be loaded
    off the stack. */
	ta	0x03
	ld	[%o0], %fp		/* old sp, now frame */
	add	%fp, -64, %sp		/* room for kernel save area */
	ld	[%o0+4], %o7		/* return address */
	jmpl	%o7+8, %g0		/* return */
	restore	%g0, 1, %o0		/* return 1 */

	.globl _flush_windows
_flush_windows:
/* This routine is called by _store() so it can do a bcopy without
   worrying about cached frames.  The problem here is that we'll get
   window underflows when we return. */
	retl
	ta	0x03

/* The store/cook/etc interface does not mesh well with the ST_SLUSH_WINDOWS
   trap.  What we really want is a trap to clear the WIM when we do a cook(),
   and a trap that flushes the windows without affecting the WIM when we
   do a store().  */
