/* define your machine type here, if cpp won't */

/* #define mips /**/
/* #define sparc /**/
/* #define mc68000 /**/
/* #define u3b2 /**/
/* #define vax /**/
/* #define i386  /**/
  
/*
 * Internal machine states are used to preserve the environment of the
 * function(s) running on a node.  The `_process_table' of processes for the
 * nodes in the simulation is the only use of internal machine states.
 * 
 * An internal machine state is a structure as defined below:
 */

typedef struct machine_state
{
#ifdef vax
    int             fp;                 /* frame pointer */
    int             entry;              /* frame entry mask, old psw  */
    int             ap;                 /* argument pointer */
    int             sp;                 /* stack (frame) pointer */
    int             pc;                 /* program counter */
    int             registers[10];      /* machine registers r2-r11 */
    int             argcount;           /* number of args on stack */
#endif

#ifdef mc68000
    int             pc;                 /* program counter */
    int             registers[10];      /* d2-7,a2-5 */
    int             fp;                 /* frame pointer */
    int             sp;                 /* stack pointer */
#endif

#ifdef hp9000s200
    int             pc;                 /* program counter */
    int             registers[10];      /* d2-7,a2-5 */
    int             fp;                 /* frame pointer */
    int             sp;                 /* stack pointer */
#endif

#ifdef u3b2
    int             pc;                 /* program counter */
    int             ap;                 /* argument pointer */
    int             fp;                 /* frame pointer */
    int             sp;                 /* stack pointer */
    int             registers[6];       /* r3-8 */
#endif

#ifdef mips
    int 	    pc; 		/* $31 */
    int 	    sp; 		/* $29 */
    int 	    gp;			/* $28 */
    int 	    f31;	        /* f31 of the coprocessor */
    int 	    r30;		/* r30 */
    int	            regs [8];		/* $16-$23 */
    int 	    fregs [12];	        /* f20-f31 */
    int	            extra [5];		/* just to be sure */
#endif

#ifdef sparc
    int fp;
    int pc;
#endif
 
#ifdef i386
    int pc;                   /* %eip */
    int fp;                   /* %ebp */
    int regs[5];              /* %ebx, %ecx, %edx, %edi, %esi */
    int sp;                   /* %esp */
    char fpustate[108];
#endif

} istate;

