/* define your machine type here, if cpp won't */
/* #define mips /**/
/* #define sparc /**/
/* #define mc68000 /**/
/* #define u3b2 /**/
/* #define vax /**/
/* #define i386 /**/


/*
 * Nest simulation library - stack / register manipulation routines
 */

/*
 * The first step in porting this module, containing the only assembler code
 * in Nest, is to familiarize yourself with the calling conventions for the
 * C compiler on your machine.  The part indicated by "changing contents" is
 * different for each function called by s_main.  This is the part which
 * must be saved when we switch from node to node.  Here is a picture of the
 * machine state after an assembler function has been called by s_main():
 *
 * On a Vax, the stack grows towards low memory.  The arguments (if any) are
 * pushed on the stack by s_main, and the argument count and stack frame
 * (saved registers, sp, pc and junk) are pushed on the stack by the call.
 */

/*---------------------------------------------------------------------------+
 |                                                     lower addresses       |
 |              |                       |                        |           |
 |              =========================               ===      |           |
 | sp => fp =>  |   condition handler   |                |       |           |
 |              | save mask | saved psw |                |       |           |
 |              |       saved ap        |                |       |           |
 |              |       saved fp        |                |       |           |
 |              |       saved pc        |                |(changing contents)|
 |              |- - - - - - - - - - - -|                |       |           |
 |              .    saved registers    .                |       |           |
 |              .       (if any)        .                |       |           |
 |              |-----------------------|       (established by s_main)      |
 | ap =>        |       arg count       |                |       |           |
 |              |-----------------------|                |       |           |
 |              .  args for this funct  .                |       |           |
 |              .       (if any)        .                |       |           |
 |              |-----------------------|                |      ===          |
 |              .        s_main         .                |                   |
 |              .        locals         .                |                   |
 |              =========================               ===                  |
 |              |                       |                |                   |
 |              |      stack frame      |       (established by simulate)    |
 |              .                       .                |                   |
 |                                                    higher addresses       |
 +---------------------------------------------------------------------------*/

/*
 * On most MC68010 or MC68020 machines the stack grows towards low memory.
 * The arguments (if any) are pushed on the stack by s_main, and only the
 * return address is pushed by the call.  Registers aren't saved in the
 * call.
 */

/*---------------------------------------------------------------------------+
 |                                                     lower addresses       |
 |              |                       |                        |           |
 |              =========================               ===      |           |
 | sp (a7) =>   | return for this funct |                |(changing contents)|
 |              |-----------------------|                |       |           |
 |              .  args for this funct  .                |       |           |
 |              .       (if any)        .                |       |           |
 |              |-----------------------|                |      ===          |
 |              .    saved registers    .       (established by s_main)      |
 |              .     s_main locals     .                |                   |
 |              |-----------------------|                |                   |
 | fp (a6) =>   |   pointer to old fp   |                |                   |
 |              =========================               ===                  |
 |              |   return for s_main   |                |                   |
 |              |-----------------------|       (established by simulate)    |
 |              |                       |                |                   |
 |                                                    higher addresses       |
 +---------------------------------------------------------------------------*/

/*
 * On most WE32000 machines (3b2 series) the stack grows towards high memory.
 * The arguments (if any) are pushed on the stack by s_main, and the old ap
 * and pc are pushed on the stack by the call.
 */

/*---------------------------------------------------------------------------+
 |                                                     lower addresses       |
 |              .                       .                |                   |
 |              |      stack frame      |       (established by simulate)    |
 |              |                       |                |                   |
 |              =========================               ===                  |
 |              .    saved registers    .                |                   |
 |              |-----------------------|                |                   |
 | fp =>        .     s_main locals     .                |                   |
 |              |-----------------------|                |      ===          |
 | ap =>        .  args for this funct  .       (established by s_main)      |
 |              .       (if any)        .                |       |           |
 |              |-----------------------|                |       |           |
 |              |       saved pc        |                |(changing contents)|
 |              |       saved ap        |                |       |           |
 |              =========================               ===      |           |
 | sp =>        |                       |                        |           |
 |              |                       |                        |           |
 |                                                    higher addresses       |
 +---------------------------------------------------------------------------*/


#ifdef notdef

/*
 * The assembler functions in this module are based on the following
 * pseudo-C code.  Machines currently supported include Vaxen and most 68000
 * based architectures.
 */

#include "state.h"
#include "defs.h"

pointer
nest_stack ()
{
    return ((arg_ptr));
}

nest_xstack (stack)
pointer         stack;
{
    (stack_ptr) = stack;
}

#endif

/*
 * The nest_stack() function simply returns the current argument pointer, which,
 * since there are no arguments, is the highest address in the region of
 * changing contents.  It is also called from _timeout() to get the lowest
 * address in the region which is worth saving.
 *
 * The nest_xstack() function switches to a new stack, pointed to by the `stack'
 * argument.  Since we don't mess with the frame or arg pointers, the old
 * local variables and arguments are still accessible.
 */

#ifdef notdef

nest_freeze (saved)
struct state   *saved;                  /* buffer state to save to */
{
    saved->pc = (return_addr);          /* save return address */
    saved->registers = (registers);     /* save register variables */
#ifdef vax
    saved->ap = (arg_ptr);              /* save arg pointer */
#endif
    saved->fp = (frame_ptr);            /* save frame pointer */
    saved->sp = (stack_ptr);            /* save stack pointer */
}

nest_cook (saved)
struct state   *saved;                  /* buffer state to restore */
{
    (registers) = saved->registers;     /* restore register vars */
#ifdef vax
    (arg_ptr) = saved->ap;              /* restore arg pointer */
#endif
    (frame_ptr) = saved->fp;            /* restore frame pointer */
    (stack_ptr) = saved->sp;            /* restore stack pointer */
    (return_addr) = saved->pc;          /* restore return address */
}
#endif
/*
 * The nest_freeze() is functionally identical to _setjmp().  It saves the
 * general and special purpose registers, but not scratch registers or
 * condition codes, since these are somewhere on the stack, and are restored
 * by the system's signal handler call and return (trampoline) code.
 *
 * The nest_cook() function restores the information saved by nest_freeze().  It is
 * functionally identical to _longjmp(), except that the return value is
 * always 1, and it can jump to any _setjmp(), not just those higher up in
 * the calling stack.  (The contents of the stack below the current frame
 * must be loaded with valid contents for this to work, of course.)  Some
 * _setjmp()/_longjmp() implementations (Sun, not Vax) can do this, and are
 * acceptable substitutes for nest_freeze() and nest_cook().
 */

#ifdef vax

        .text
        .globl  _nest_stack
_nest_stack:
        .word   0
        movl    ap,r0                   /* return arg pointer */
        ret

        .globl  _nest_xstack
_nest_xstack:
        .word   0
        movl    4(ap),sp                /* new stack pointer */
        movl    fp,r1
        movl    8(r1),ap                /* restore ap, fp */
        movl    12(r1),fp
        jmp     *16(r1)                 /* jump directly to saved pc */

        .globl  _nest_freeze
_nest_freeze:
        .word   0xFFC                   /* save register vars in frame */
        movl    4(ap),r0
        movl    fp,(r0)+                /* save frame pointer */
        movc3   $60,4(fp),(r0)          /* save frame, numargs */
        ret                             /* return 0 (from movc3) */

        .globl  _nest_cook
_nest_cook:
        .word   0
        movl    4(ap),r0
        movl    (r0)+,fp                /* restore fp */
        movc3   $60,(r0),4(fp)          /* restore frame, numargs */
        movl    $1,r0                   /* return 1 */
        ret

#endif

#ifdef mc68000

        .text
        .globl  _nest_stack
_nest_stack:
        movl    sp,d0                   /* return stack pointer */
        rts

        .globl  _nest_xstack
_nest_xstack:
        movl    sp@,a0                  /* save our return address in a0 */
        movl    sp@(4),sp
        subql   #4,sp                   /* counteract adjust by caller */
        jmp     a0@                     /* return to old sp@ (no rts needed) */

        .globl  _nest_freeze
_nest_freeze:
        movl    sp@(4),a0               /* struct state pointer */
        movl    sp@,a0@+                /* save pc */
        moveml  #0xFCFC,a0@             /* save registers, fp, sp */
        moveq   #0,d0                   /* return 0 */
        rts

        .globl  _nest_cook
_nest_cook:
        movl    sp@(4),a0               /* struct state pointer */
        moveml  a0@(4),#0xFCFC          /* restore registers, fp, sp */
        movl    a0@,sp@                 /* restore return address */
        moveq   #1,d0                   /* return 1 */
        rts

#endif

#ifdef sparc
/* this works with SunOS 4, but not solaris... for solaris, look further */
/* code by S. McCanne at LBL */

	.text
	.globl	_nest_stack
_nest_stack:
	retl
	mov	%sp, %o0		/* return sp */

	.globl	_nest_xstack
_nest_xstack:
	add	%o0, -64, %o0		/* room for kernel save area */
	retl
	and	%o0, 0xfffffff8, %sp	/* multiple of 8 bytes */

	.globl	_nest_freeze
_nest_freeze:
	st	%sp, [%o0]		/* caller's sp, becomes _cook's fp */
	st	%o7, [%o0+4]		/* return address */
	retl
	mov	%g0, %o0		/* return 0 */

	.globl	_nest_cook
_nest_cook:
/*  First, flush the windows.  All we really want to do is make all
    the windows except the current one invalid, but I don't know how to
    do this.  (This assumes the new stack does not overlap with the
    current one.)
    We then load the new stack pointer, making sure there is room
    for the kernel if an interrupt occurs before the restore.
    Finally, we jump to the return address, and restore to the
    new stack's  window.  Since the windows have been flushed,
    an underflow trap will occur, and the frame will be loaded
    off the stack. */
	ta	0x03
	ld	[%o0], %fp		/* old sp, now frame */
	add	%fp, -64, %sp		/* room for kernel save area */
	ld	[%o0+4], %o7		/* return address */
	jmpl	%o7+8, %g0		/* return */
	restore	%g0, 1, %o0		/* return 1 */

	.globl _flush_windows
_flush_windows:
/* This routine is called by _store() so it can do a bcopy without
   worrying about cached frames.  The problem here is that we'll get
   window underflows when we return. */
	retl
	ta	0x03

/* The store/cook/etc interface does not mesh well with the ST_SLUSH_WINDOWS
   trap.  What we really want is a trap to clear the WIM when we do a cook(),
   and a trap that flushes the windows without affecting the WIM when we
   do a store().  */

#endif

#ifdef solaris
/* use this for Solaris (sunos 5.0 and greater) */
/* code by S. McCanne at LBL */

	.text
	.globl	nest_stack
nest_stack:
	retl
	mov	%sp, %o0		/* return sp */

	.globl	nest_xstack
nest_xstack:
	add	%o0, -64, %o0		/* room for kernel save area */
	retl
	and	%o0, 0xfffffff8, %sp	/* multiple of 8 bytes */

	.globl	nest_freeze
nest_freeze:
	st	%sp, [%o0]		/* caller's sp, becomes _cook's fp */
	st	%o7, [%o0+4]		/* return address */
	retl
	mov	%g0, %o0		/* return 0 */

	.globl	nest_cook
nest_cook:
/*  First, flush the windows.  All we really want to do is make all
    the windows except the current one invalid, but I don't know how to
    do this.  (This assumes the new stack does not overlap with the
    current one.)
    We then load the new stack pointer, making sure there is room
    for the kernel if an interrupt occurs before the restore.
    Finally, we jump to the return address, and restore to the
    new stack's  window.  Since the windows have been flushed,
    an underflow trap will occur, and the frame will be loaded
    off the stack. */
	ta	0x03
	ld	[%o0], %fp		/* old sp, now frame */
	add	%fp, -64, %sp		/* room for kernel save area */
	ld	[%o0+4], %o7		/* return address */
	jmpl	%o7+8, %g0		/* return */
	restore	%g0, 1, %o0		/* return 1 */

	.globl flush_windows
flush_windows:
/* This routine is called by _store() so it can do a bcopy without
   worrying about cached frames.  The problem here is that we'll get
   window underflows when we return. */
	retl
	ta	0x03

/* The store/cook/etc interface does not mesh well with the ST_SLUSH_WINDOWS
   trap.  What we really want is a trap to clear the WIM when we do a cook(),
   and a trap that flushes the windows without affecting the WIM when we
   do a store().  */

#endif

#ifdef hp9000s200

        text
        global  _nest_stack
_nest_stack:
        move.l  %sp,%d0                  /* return stack pointer */
        rts

        global  _nest_xstack
_nest_xstack:
        move.l  (%sp),%a0               /* save our return address in a0 */
        move.l  4(%sp),%sp
        sub.l   &4,%sp                  /* counteract adjust by caller */
        jmp     (%a0)                   /* return to old sp (no rts needed) */

        global  _nest_freeze
_nest_freeze:
        move.l  4(%sp),%a0              /* struct state pointer */
        move.l  (%sp),(%a0)+            /* save pc */
        movm.l  &0xFCFC,(%a0)           /* save registers, fp, sp */
        move.l  &0,%d0                  /* return 0 */
        rts

        global  _nest_cook
_nest_cook:
        move.l  4(%sp),%a0              /* struct state pointer */
        movm.l  4(%a0),&0xFCFC          /* restore registers, fp, sp */
        move.l  (%a0),(%sp)             /* restore return address */
        move.l  &1,%d0                  /* return 1 */
        rts

#endif

#ifdef u3b2

        .text
        .align  4
        .globl  nest_stack
nest_stack:
        movw    %ap,%r0                 /* return arg pointer */
        RET

        .align  4
        .globl  nest_xstack
nest_xstack:
        movw    %sp,%r1
        movw    (%ap),%sp               /* new stack pointer */
        movw    -4(%r1),%ap             /* restore ap */
        movw    -8(%r1),%r2
        jmp     0(%r2)                  /* jump directly to saved pc */

        .align  4
        .globl  nest_freeze
nest_freeze:
        movw    (%ap),%r1               /* struct state pointer */
	movw    -8(%sp),0(%r1)          /* save pc */
	movw    -4(%sp),0x4(%r1)        /* save ap */
	movw    %fp,0x8(%r1)            /* save fp */
	movw    %ap,0xc(%r1)            /* save sp */
	movw    %r3,0x10(%r1)           /* save registers */
	movw    %r4,0x14(%r1)
	movw    %r5,0x18(%r1)
	movw    %r6,0x1c(%r1)
	movw    %r7,0x20(%r1)
	movw    %r8,0x24(%r1)
        movw    &0,%r0                  /* return 0 */
        RET

        .align  4
        .globl  nest_cook
nest_cook:
        movw    (%ap),%r1               /* struct state pointer */
	movw    0x4(%r1),%ap            /* restore ap */
	movw    0x8(%r1),%fp            /* restore fp */
	movw    0xc(%r1),%sp            /* restore sp */
	movw    0x10(%r1),%r3           /* restore registers */
	movw    0x14(%r1),%r4
	movw    0x18(%r1),%r5
	movw    0x1c(%r1),%r6
	movw    0x20(%r1),%r7
	movw    0x24(%r1),%r8
	movw    0(%r1),%r2              /* set up return address */
	movw    &1,%r0                  /* return 1 */
	jmp     0(%r2)

#endif

#ifdef notdef

/*
 * This extra assembler cruft is needed for Suns, which have a gratuitous
 * change to setjmp/longjmp that coerces a zero return value from longjmp
 * into a one, so that longjmp (env, 0) is the same as longjmp (env, 1).
 * This was a really stupid thing for Sun to do, since it is incompatible
 * with nearly every other implementation of setjmp/longjmp.
 *
 * So here is an improved implementation, based (sort of) on the 4.3 Vax
 * setjmp/longjmp, which fixes the `on signal stack' bug.  If and when Sun
 * ever implements sigreturn() this should be modified to use it.  At any
 * rate, feel free to use these in other programs.
 *
 */

/*-
 * C library -- setjmp, longjmp
 *
 *      longjmp(a,v)
 * will generate a "return(v)" from
 * the last call to
 *      setjmp(a)
 * by restoring registers from a jmp_buf
 * which is set up as:
 *
 * struct jmp_buf {
 *      int     jb_pc;                  /* pc to restore
 *      int     jb_sigmask;             /* signal mask to restore
 *      int     jb_onsigstack;          /* on sigstack state to restore
 *      int     jb_registers[12];       /* registers d2-d7,a2-a7 to restore
 * }
 * [should use a struct sigcontext, see <signal.h>, but we'll do it sun's way]
 */

#endif 

#ifdef sun

        .text
        .globl  _sigblock
        .globl  _sigstack

        .globl  _setjmp
_setjmp:
        movl    sp@(4),a0               /* pointer to jmp_buf */
        movl    sp@,a0@+                /* save pc of caller */
        clrl    sp@-
        jbsr    _sigblock               /* get signal mask */
    /*  addql   #4,sp                   /* unneeded, since we subql below */
        movl    d0,a0@+                 /* save signal mask of caller */
        subql   #4,sp                   /* reserve struct sigstack (8 bytes) */
        pea     sp@                     /* get current values */
        clrl    sp@-                    /* no new values */
        jbsr    _sigstack
        lea     sp@(12),sp              /* pop args plus signal stack value */
        movl    sp@+,a0@+               /* save onsigstack status of caller */
        moveml  #0xFCFC,a0@             /* save registers of caller */
        moveq   #0,d0
        rts

        .globl  _longjmp
_longjmp:
        subql   #8,sp                   /* space for struct sigstack */
        pea     sp@                     /* get current values */
        clrl    sp@-                    /* no new values */
        jbsr    _sigstack
    /*  addql   #8,sp                   /* unneeded, since we reuse 0 arg */
        movl    sp@(20),a0              /* pointer to jmp_buf */
        movl    a0@(8),sp@(12)          /* copy onsigstack status of caller */
        pea     sp@(8)                  /* set new values */
        jbsr    _sigstack
        lea     sp@(20),sp              /* pop 3 args plus struct sigstack */
        movl    sp@(4),a0               /* pointer to jmp_buf */
        movl    a0@(4),sp@-
        jbsr    _sigsetmask             /* restore signal mask of caller */
    /*  addql   #4,sp                   /* unneeded, since we moveml below */
        movl    sp@(12),d0              /* return (v) */
        movl    sp@(8),a0               /* pointer to jmp_buf */
        movl    a0@,a1                  /* get return address from setjmp */
        moveml  a0@(12),#0xFCFC         /* restore registers */
        addql   #4,sp                   /* adjust since we don't rts */
        jmp     a1@

#endif

#ifdef mips

.option pic2
.text 				## code by S.Keshav, UCB/AT&T
.align 2

.globl nest_stack
.ent nest_stack
nest_stack:
	.frame $sp,  0,  $31
	move $2,  $sp 		## return stack pointer
	j $31 			## return
.end nest_stack

.text
.align 2
.globl nest_xstack
.ent nest_xstack
nest_xstack:
	.frame $sp,  0 ,  $31
	move  $sp,  $4		## new stack pointer
        sw $gp, 32($sp)         ## needed for position indep. code
	j $31			## return
.end nest_xstack

.text
.align 2
.globl nest_freeze
.ent nest_freeze
nest_freeze:
	.frame $sp,  0,  $31
	cfc1        $2, $31 
	sw  $31, 0xc ($4)
	sw  $29, 0x8 ($4)
	sw  $2, 0x68 ($4)
	sw  $30, 0x34 ($4)
	sw  $16, 0x14 ($4)
	sw  $17, 0x18 ($4)
	sw  $18, 0x1c ($4)
	sw  $19, 0x20 ($4)
	sw  $20, 0x24 ($4)
	sw  $21, 0x28 ($4)
	sw  $22, 0x2c ($4)
	sw  $23, 0x30 ($4)
	swc1        $f21, 0x38 ($4)
	swc1        $f20, 0x3c ($4)
	swc1        $f23, 0x40 ($4)
	swc1        $f22, 0x44 ($4)
	swc1        $f25, 0x48 ($4)
	swc1        $f24, 0x4c ($4)
	swc1        $f27, 0x50 ($4)
	swc1        $f26, 0x54 ($4)
	swc1        $f29, 0x58 ($4)
	swc1        $f28, 0x5c ($4)
	li 	    $6, 0x0
	move        $2, $6	## return 0
	swc1        $f31, 0x60 ($4)
	j  $31
	swc1        $f30, 0x64 ($4)	## delay slot
.end nest_freeze	
	
.text
.align 2
.globl nest_cook
.ent nest_cook
nest_cook:	
	.frame $sp,  0,  $31
	lw  $2, 0x68 ($4)
	lw  $31, 0xc ($4)
	ctc1        $2, $31
	lw  $29, 0x8 ($4)
	lw  $30, 0x34 ($4)
	lw  $16, 0x14 ($4)
	lw  $17, 0x18 ($4)
	lw  $18, 0x1c ($4)
	lw  $19, 0x20 ($4)
	lw  $20, 0x24 ($4)
	lw  $21, 0x28 ($4)
	lw  $22, 0x2c ($4)
	lw  $23, 0x30 ($4)
	lwc1        $f21, 0x38 ($4)
	lwc1        $f20, 0x3c ($4)
	lwc1        $f23, 0x40 ($4)
	lwc1        $f22, 0x44 ($4)
	lwc1        $f25, 0x48 ($4)
	lwc1        $f24, 0x4c ($4)
	lwc1        $f27, 0x50 ($4)
	lwc1        $f26, 0x54 ($4)
	
	lwc1        $f29, 0x58 ($4)
	lwc1        $f28, 0x5c ($4) 
	lwc1        $f31, 0x60 ($4)
	li 	    $6, 0x1
	move        $2, $6	## return 1
	lwc1        $f30, 0x64 ($4)
	j  $31
.end nest_cook

#endif

#ifdef i386
				# Code by Elan Amir, UCB
.text
	.align 2
.globl nest_stack
nest_stack:
	popl %ebx		# pop return address
	movl %esp,%eax		# return stack pointer
	
	jmp %ebx		# don't want ret so we don't alter esp.

	.align 2
.globl nest_xstack
nest_xstack:
	popl %eax		# pop return address

	movl (%esp),%esp	# store new stack pointer in sp.
	
	jmp %eax		# don't want ret so we don't alter esp.

	.align 2
.globl nest_freeze
nest_freeze:
	
	movl 4(%esp),%eax	# eax = saved

	movl %ebp, 4(%eax)	# save fp.
	movl %ebx, 8(%eax)	# Save general regs
	movl %ecx, 12(%eax)	
	movl %edx, 16(%eax)	
	movl %esi, 20(%eax)
	movl %edi, 24(%eax)
	movl %esp, 28(%eax)	# save sp
	fnsave 32(%eax)		# save fpu state

	movl (%esp),%ecx        # save pc
	movl %ecx,(%eax)	

	movl $0, %eax		# return 0
	ret			

	.align 2
.globl nest_cook
nest_cook:
	popl %ecx		# forget calling pc on stack

	movl (%esp), %eax	# eax = saved
	
	movl 4(%eax), %ebp	# restore fp
	movl 8(%eax), %ebx	# restore general regs
	movl 12(%eax), %ecx	
	movl 16(%eax), %edx	
	movl 20(%eax), %esi
	movl 24(%eax), %edi
	movl 28(%eax), %esp	# restore sp
	frstor 32(%eax)		# restore fpu state
	
	pushl (%eax)		# push new pc on stack
	movl $1, %eax		# return 1
	ret			# return thereby restoring pc.
#endif /* i386 */

#ifdef __alpha
				# code by S. Keshav, Cornell, 8/8/97
				# no need for cook/freeze use setjmp/longjmp
        .set noat
        .set noreorder
        .text
        .align 4

        .globl  nest_stack
        .ent    nest_stack

nest_stack:
        .frame  $sp, 0, $26
        .save_ra $0
        .prologue 0
        bis     $sp, $sp, $0         # move sp to return register
        ret     ($26)
        .end    nest_stack

        .globl  nest_xstack
        .ent    nest_xstack
nest_xstack:
        .frame  $sp, 0, $26
        .save_ra $0
        .prologue 0

        bis     $16, $16, $sp       # move the argument to the stack pointer
        ret     ($26)
        .end    nest_xstack
#endif
