/*
 * Nest simulation library - global internal variables
 * 
 * $Header: simulate.h,v 2.5 88/03/31 14:50:27 dupuy Rel $
 */

/*
 * Define nest internal global variables which are used throughout the
 * simulation layer.
 */

#include "copyright.h"                  /* include legal nonsense */
#include <setjmp.h>

#define NewPass 2                       /* longjmp can't return 0, -sigh- */

extern flag     _swapping;              /* `on swap stack' indication */

extern jmp_buf  _scheduler;             /* jump buffer for top of "loop" */
extern char    *_stackbase;             /* base of the swapped stack */
extern timev    _passtime;              /* length of simulation passes */

extern timev    _sync_time;             /* synchronization time of this pass */

/*
 * Define diagnostic macros
 */

#define fatal(message)  longjmp (_scheduler, _error (message))

/*
 * Declare internal functions
 */

extern ident    _get_next_node ();
extern ident    _next_pass ();

extern char    *_stack ();
extern timev   *_check_queue ();
extern timev    _stop_count ();
