/*
 * Nest simulation library - simulation server and graphlanguage functions
 * 
 */


#include "nest.h"
#include "graph.h"
#include "defs.h"
#include "simulate.h"
#include "process.h"

static graph   *graf;
unsigned Nodes = 0;
unsigned StackSize = 0;
unsigned PortNumber = 0;
struct graph *Graph;
boolean  Altered;                /* if network has changed this pass */
long     Delay;                  /* default edge transmission delay */
ident    _current_node;          /* use get_node_id() macro instead */
timev time_zero;
timev time_result;
ident    _current_node;

/* ARGSUSED */
_serv_init (nodes, initgraph, port)
    unsigned        nodes;
    graph          *initgraph;
    int             port;
{
    if (initgraph is nil)	/* create graph with entries zeroed */
	initgraph = newarray (1, graph);

    set_options (nodes, initgraph);	/* fix options and flag settings */
    graf = initgraph;
    input_graph (graf);		/* set initial network graph */
    return (None);
}


static
set_options (nodes, initgraf)
    unsigned        nodes;
    graph          *initgraf;
{
    initgraf->flags |= Node_IDs | Positions;
    initgraf->protocol = Nest_Graph;

    if (initgraf->header is nil)
    {
	initgraf->header = new (grhead);

	initgraf->header->passtime.tv_sec = 1;
	initgraf->header->passtime.tv_usec = 0;
	initgraf->header->wakeups = time_zero;
	initgraf->header->unused = 0;
	initgraf->header->point2point = false;
	initgraf->header->delay = 10000;
	initgraf->header->nodefns = nil;
	initgraf->header->chanfns = nil;
	initgraf->header->monfns = nil;
    }
    initgraf->header->timenow = time_zero;
    initgraf->header->nodes = nodes;
}


static
input_graph (newgraf)
    graph          *newgraf;
{
    grhead     *head;
    gredge    **edges;
    grnode     *nodes;
    grnode    **nodelist;

    ident           node1, node2;

    head = newgraf->header;	/* set global variables */

    Delay = head->delay;

    _passtime = head->passtime;

    nodes = newgraf->nodes;
    foreach (nodes)
    {
        _proc_table[nodes->nodedata->nodeid].function = 
				nodes->nodedata->function;
        nodes->nodedata->start = false;
    }

    edges = &newgraf->edges;

    while (*edges isnt nil)
    {
	node1 = (*edges)->node1->nodedata->nodeid;
	node2 = (*edges)->node2->nodedata->nodeid;

	if (node1 isnt nil_id and node2 isnt nil_id)
	{
	    _neighbor_update (node1, node2, (*edges)->edgedata);
	    _neighbor_update (node2, node1, (*edges)->edgedata);
	}
        advancn (edges);
    }

    nodelist = &newgraf->nodes;

    while (*nodelist isnt nil)
    {
	if ((*nodelist)->nodedata->function is nil)
	    dropn (nodelist);	/* delete unallocated node */
	else
	    advancn (nodelist);
    }
}

