/*
 * Nest simulation library - scheduler definitions
 * 
 * $Header: schedule.h,v 2.5 88/03/31 14:50:17 dupuy Rel $
 */

/*
 * Node queues are used to order the nodes in a network, and break down the
 * whole network into subset queues.  The `_sched_table' of node queues is
 * currently the only use of node queues.
 * 
 * A node queue is a queue of node id's as defined below; an end of the queue is
 * marked by a `next' or `prev' field of nil:
 */

typedef struct node_queue *nodeptr;
typedef struct node_queue **nodequeue;
typedef struct node_queue
{
    nodeptr         next,               /* next node on the node queue */
                    prev;               /* previous node on node queue */

    ident           n_id;               /* node id of this node */
    timev	    unblocked;		/* time the node can run */
} node;

/*
 * The next and prev fields point to the two adjacent nodes in the node queue,
 * and allow a node to be unlinked from a queue without knowing the node which
 * is previous to it; otherwise only the next field would be needed, for
 * determining the next node to run.
 * 
 * The n_id field allows one to determine the node id number of the next node,
 * although it is redundant when accessing the node by a node id indexed entry
 * in the _sched_table.
 */

/*
 * The following are integer codes for process states which are actually
 * represented by being in one of the various scheduler queues.  They are used
 * as arguments by functions which manipulate the scheduler table, so that a
 * function which deals with the process table can ignore scheduler types.
 */

#ifndef DoneQueue
#define DoneQueue            0
#define BlockedQueue        -1
#define WaitQueue            1
#define NewpassWaitqueue     2
#endif

/*
 * Internal scheduler functions.
 */

extern nodeptr  _push_node ();
extern nodeptr  _sort_sched ();
extern nodeptr  _waitqueue_create ();


/*
 * The `_sched_table', which holds the four distinct scheduling queues that
 * make up the scheduler database, is an array (indexed by node id's) of
 * "node_queue" structures, with embedded node queues known as the execution,
 * new (or next) pass, blocked, and done queues, and is defined like this:
 */

extern nodeptr  _sched_table;           /* size of `nodes' arg to simulate() */

extern nodeptr  _done_queue;            /* nodes whose functions returned */
extern nodeptr  _blocked_queue;         /* nodes which have blocked on recv */

extern nodeptr  _execution_last;        /* last node on execution queue */

extern nodeptr  _wait_queue;            /* #1 waiting node on exec. queue */

extern nodeptr  _next_waitqueue;        /* #1 waiting node on new pass queue */

extern nodeptr  _next_queue;            /* #1 node for next scheduler pass */

extern nodeptr  _next_last;             /* last node for next scheduler pass */

/*
 * no `_execution_queue' variable exists; since _current_node is the node id
 * of the first node on the execution queue, a node pointer would be
 * redundant.
 */
