/*
 * Nest simulation library - network definitions
 * 
 * $Header: network.h,v 2.5 88/03/31 14:49:49 dupuy Rel $
 */

#ifndef Nest_Flags
#include "graph.h"                      /* to get channel stacks */
#endif

/*
 * Neighbor lists are used to keep track of the neighbor relations of the
 * nodes in a network.  The `_network_table' of the neighbors of each node is
 * currently the only use of neighbor lists.
 * 
 * A neighbor list is a singly linked list of node id's as defined below; the end
 * of the list is marked by a `next' field of nil:
 */

typedef struct neighbor_list
{
    struct neighbor_list *next;         /* pointer to the next neighbor */

    ident           nbr;                /* node id of this neighbor node */
    long            weight;             /* transmission delay (usecs) */
    chanptr         chanstack;          /* channel function stack */
} neighbor;

/*
 * A neighbor list specifies all the neighbors of a single node; it is not a
 * complete specification of a network.  The neighbor lists of all the nodes
 * in a network together are a complete specification of a network
 * 
 * The delay and channel fields are taken from an entry in the edge list; their
 * use is as defined there, except that a neighbor list is a strictly
 * directional graph, from some node, to the neighbors on the list. Therefore
 * these fields would only be used when sending a message to the nodes on the
 * list, and never when sending from them.
 */


/*
 * The `_network_table', which keeps track of the neighbors of each node, is
 * an array (indexed by node id's) of "neighbor_list" structure pointers, and
 * is defined like this:
 */

extern neighbor **_network_table;       /* size of `nodes' arg to simulate() */
