/*
 * Nest simulation library - network routines
 * 
 * $Header: network.c,v 2.5 88/03/31 14:49:44 dupuy Rel $
 */

#include "nest.h"
#include "graph.h"
#include "defs.h"
#include "network.h"

/* Global */

neighbor **_network_table;       /* size of `nodes' arg to simulate() */

/*
 * Initial allocation of network table
 */

_network_init (nodes)
unsigned        nodes;
{
    _network_table = (neighbor **) calloc (nodes + 1, sizeof (neighbor *));
}


/*
 * Return a sorted node list of neighbors
 */

node_ptr        _get_nbrs (nodeid)
ident           nodeid;
{
    neighbor       *neighptr;
    node_ptr        nbrptr;
    node_list       listptr;

    nbrptr = nil;

    neighptr = _network_table[nodeid];

    foreach (neighptr)                  /* one neighbor is one node */
    {
        node_ptr        tempptr;

        listptr = &nbrptr;
        while ((*listptr) isnt nil and (*listptr)->id < neighptr->nbr)
            advancn (listptr);

        if ((*listptr) is nil or
                (*listptr)->id isnt neighptr->nbr)
        {                               /* only add new neighbors to list */
            tempptr = new (node_item);
            tempptr->id = neighptr->nbr;
            insn (tempptr, listptr);
        }
    }

    return (nbrptr);
}



/*
 * Update neighbor entry from graph edge data
 */

_neighbor_update (node1, node2, edgedata)
ident           node1,
                node2;
gredgedat      *edgedata;
{
    neighbor      **neighptr;
    chanptr         copy_funclist ();

    /* update and/or add node2 entry on node1s neighbor list */

    neighptr = &_network_table[node1];

    while (*neighptr isnt nil and (*neighptr)->nbr isnt node2)
        advancn (neighptr);

    if (*neighptr is nil)               /* not on neighbor list */
    {
        *neighptr = new (neighbor);
        (*neighptr)->next = nil;
        (*neighptr)->nbr = node2;
        (*neighptr)->chanstack = nil;
    }

    (*neighptr)->weight = edgedata->weight;
    (*neighptr)->chanstack = copy_funclist (edgedata->chanstack);
}

chanptr         copy_funclist (funclist)
reg chanptr     funclist;
{
    chanptr         result;
    reg chanlist    newlist = &result;

    foreach (funclist)
    {
        (*newlist) = new (chanfunc);
        (*newlist)->addr = funclist->addr;
        advancn (newlist);
    }
    *newlist = nil;

    return (result);
}

