/*
 * Nest simulation library - generic main routine argument parser
 * 
 * $Header: nestargs.c,v 2.5 88/03/31 14:49:41 dupuy Rel $
 */

#include "nest.h"
#include "graph.h"
#include "defs.h"

int             nest_parse_args (argc, argv)
int             argc;
char           *argv[];

{
    extern          getopt ();
    extern char    *optarg;
    extern int      optind;
    int		    c;

    while ((c = getopt (argc, argv, "p:")) isnt -1)
        switch (c)
        {
         case 'p':
           PortNumber = htons (atoi (optarg));
	   break;

          case '?':
            usage ("");
            break;
	}
    return; 
}

static          usage (message)
char           *message;
{
    (void) fprintf (stderr, "%s valid options are:\n", message);
    (void) fprintf (stderr, " -p: GUI port number. Use simulate -p port# filename.l ");
}


#ifndef GETOPT

/*
 * get option letter from argument vector
 */
int             opterr = 1,             /* useless, never set or used */
                optind = 1,             /* index into parent argv vector */
                optopt;                 /* character checked for validity */
char           *optarg;                 /* argument associated with option */

#define BADCH   (int)'?'
#define EMSG    ""
#define tell(s) (void)fputs(*nargv,stderr);(void)fputs(s,stderr); \
             (void)fputc(optopt,stderr);(void)fputc('\n',stderr);return(BADCH);

getopt (nargc, nargv, ostr)
int             nargc;
char          **nargv,
               *ostr;
{
    static char    *place = EMSG;       /* option letter processing */
    register char  *oli;                /* option letter list index */
    char           *index ();

    if (!*place)
    {                                   /* update scanning pointer */
        if (optind >= nargc || *(place = nargv[optind]) != '-' || !*++place)
            return (EOF);
        if (*place == '-')
        {                               /* found "--" */
            ++optind;
            return (EOF);
        }
    }                                   /* option letter okay? */
    if ((optopt = (int) *place++) == (int) ':'
            || !(oli = index (ostr, optopt)))
    {
        if (!*place)
            ++optind;
        tell (": illegal option -- ");
    }
    if (*++oli != ':')
    {                                   /* don't need argument */
        optarg = NULL;
        if (!*place)
            ++optind;
    }
    else
    {                                   /* need an argument */
        if (*place)
            optarg = place;             /* no white space */
        else if (nargc <= ++optind)
        {                               /* no arg */
            place = EMSG;
            tell (": option requires an argument -- ");
        }
        else
            optarg = nargv[optind];     /* white space */
        place = EMSG;
        ++optind;
    }
    return (optopt);                    /* dump back option letter */
}

#endif
