/*
 * Nest simulation library - external definitions
 * 
 * $Header: nest.h.SH,v 2.5 88/03/31 20:41:21 dupuy Rel $
 */

#if (7 & 1) != 1
#define void int		/* is void to be avoided? */
#define M_VOID			/* Xenix strikes again */
#endif

#define	CHARSPRINTF 	/* defined if char *sprintf() */
#define	VOIDSIG 	/* defined if void (*signal())() */

#define	GETOPT		/* defined if getopt() is available */
#define	ITIMER		/* defined if setitimer() is available */
#define	SYSTIME	"/usr/include/sys/time.h"	/* pathname of file defining struct timeval */

#define	MEMSET		/* defined if memory functions are available */
#define	BSTRING		/* defined if bstring functions available */

#define	PSIGNAL		/* defined if psignal() is available */
#define	RENAME		/* defined if rename() is available */
#define	RUSAGE		/* defined if getrusage() is available */

#define	SIGVEC		/* defined if sigvec() is available */
#undef	SIGVECTOR	/* defined if hp-ux has changes to sigvec */

#define	STACKDIR -1	/* -1: stack grows down; 1: stack grows up */

#include <stdio.h>
#include <malloc.h>

#ifdef CHARSPRINTF
extern char *sprintf ();		/* if that's how it is */
#endif
#define ssprintf (void) sprintf

#include "/usr/include/sys/time.h"

#include "dcctime.h"                    /* nest uses time structs all over */

/*
 * Result codes
 */

#define Normal  1                       /* normal status result */
#define None    0                       /* no special status result */
#define Error  -1                       /* error status result */

/*
 * Basic types
 */

typedef unsigned char boolean;          /* small boolean */
typedef unsigned ident;                 /* generic object identifier number */
typedef int     (*function) ();         /* function pointer */

#define nil_id  0                       /* "undefined" identifier's number */

/*
 * Global variables set by nest_parse_args, main and simulate
 */

extern unsigned Nodes;
extern unsigned StackSize;
extern unsigned PortNumber;
extern struct graph *Graph;

extern boolean  Altered;                /* if network has changed this pass */

/*
 * Set from graphlanguage header
 */

extern boolean  Logging;                /* simulation status report logging */
extern long     Delay;                  /* default edge transmission delay */

/*
 * Function declarations
 */

extern ident    recvm ();
extern int      sendm ();

extern  int     any_messages ();
extern timev    runtime ();
extern timev    cputime ();

extern  int     reliable ();

extern char    *nbread ();

extern ident    _current_node;          /* use get_node_id() macro instead */

/*
 * Macro definitions
 */

#define get_node_id() (_current_node)
#define hold()
#define release()
