/*
 * Nest simulation library - message definitions
 * 
 * $Header: message.h,v 2.5 88/03/31 14:49:35 dupuy Rel $
 */

/*
 * Message lists are used to keep track of communications between nodes. The
 * `_message_table' of messages waiting to be received is the main use of
 * message lists, however, the `message_log' which can keep track of all the
 * messages that are sent is another example.
 * 
 * A message list is a singly linked list of pointers to "message_unit"
 * structures as defined below; the end of the list is marked by a `next'
 * field of nil:
 */

typedef struct message_unit
{
    long            key;                /* message code (as defined by user) */
    char           *dataptr;            /* pointer to message data (on heap) */
    ident           sender;             /* node id of message sender */
    ident           dest;               /* node id of destination (0 = all) */
    timev           sent;               /* time that message was sent */
    timev           arrived;            /* time that message arrived */
} message;

typedef struct message_list
{
    struct message_list *next;          /* pointer to next message on list */
    message        *msg;                /* pointer to message data */
} messlist;

/*
 * The reason for having two structures, rather than one, is so that it is
 * possible to define and use a doubly linked list (or other data structure)
 * of "message_unit" structures with an alternate definition of "messlist".
 * 
 * The key and dataptr fields are the text of the message, which is taken
 * verbatim from the arguments to send(), and isn't interpreted at all.
 * 
 * The sender and dest fields are the respective node id's of the sender and
 * destination nodes.  
 * 
 * The sent field is the (simulation) time that the message was sent; the arrived
 * field is the (simulation) time that the message became available for recv()
 * calls.
 */

/*
 * The `_message_table', which keeps track of messages which haven't yet been
 * received, is simply an array (indexed by node id's) of pointers to
 * "message_list" structures, and is defined like this:
 */

extern messlist **_message_table;       /* size of `nodes' arg to simulate() */
