/*
 * Nest simulation library - send/recv message routines
 * Gutted sendm(), merged sendm.c messes.c recvm.c.. keshav 7/7/97
 */

#include "nest.h"

#include "defs.h"
#include "simulate.h"
#include "message.h"
#include "network.h"
#include "process.h"
#include "schedule.h"


#define D(x) 

messlist **_message_table;       /* size of `nodes' arg to simulate() */

sendm (dest, key, dataptr)              /* sends a message; returns status */
ident           dest;                   /* destination node (0 for all nbrs) */
long            key;                    /* message code (user defined int) */
char           *dataptr;                /* pointer to message data (on heap) */
{
    return tx_chan(dest, _current_node, dest, key, dataptr);
	/* this calls reliable, which calls _reschedule */
}


/* VARARGS 6 */

int 
reliable (a_node, sender, dest, key, dataptr, delay)
    ident           a_node,	/* actual destination node (never 0) */
                    sender,	/* sender (usually _current_node) */
                    dest;	/* destination node (0 if all nbrs) */
    long            key;	/* message code (user defined int) */
    char           *dataptr;	/* pointer to message data (on heap) */
    long            delay;	/* time at which message will arrive */
{
    messlist      **mlist, *newitem;
    message        *newmsg;
    process	    this_proc;
    timev	    arrivedtime;

    D(printf("Reliable called: sender %d, dest %d, delay %d\n", sender, dest, delay);)

    if (dataptr is 0)
    {
	printf ("attempt to deliver null msg in reliable\n");
	printf ("sender %d, dest %d, a_node %d, _current_node %d\n",
		sender, dest, a_node, _current_node);
	exit (0);
    }

    if (a_node is 0 or a_node > Nodes)	/* a_node must be a valid node */
	return (0);

    /* create "message_unit" and "message_list" structures */

    newitem = new (messlist);
    newitem->msg = newmsg = new (message);

    /* set "message_unit" fields */

    newmsg->key = key;
    newmsg->dataptr = dataptr;
    newmsg->sender = sender;
    newmsg->dest = dest;

    /* update sent and arrived time and blocked status of new message */

    if (delay is 0)
	delay = Delay; 	/* the default */

    this_proc = _proc_table[_current_node];
    newmsg->sent = this_proc.runtime;

    /* arrived time is the current runtime plus the delay */
    arrivedtime = this_proc.unblocked;
    arrivedtime.tv_sec += (arrivedtime.tv_usec += delay) / MILLION;
    arrivedtime.tv_usec %= MILLION;

    newmsg->arrived = arrivedtime;

    _reschedule (a_node, arrivedtime);

    /* insert message into message list for this node */

    mlist = &_message_table[a_node];
    while ((*mlist) isnt nil and
	   not time_after ((*mlist)->msg->arrived, newmsg->arrived))

	advancn (mlist);	/* search for later message */

    insn (newitem, mlist);	/* insert new message at this point */

    return (1);			/* this always succeeds */
}



_drop_message (messlistp)

    messlist      **messlistp;	/* address of pointer to message */
{
    messlist       *messlist_rest;


    /* free the received message and remove from messlist */

    messlist_rest = (*messlistp)->next;

    dispose ((*messlistp)->msg);
    dispose (*messlistp);

    (*messlistp) = messlist_rest;
}


_message_init (nodes)
    unsigned        nodes;
{
    _message_table = newarray (nodes + 1, messlist *);
}


timev          *
_check_queue (thisnode, fromtime, totime)
    ident           thisnode;
    timev          *fromtime, *totime;
{
    messlist       *messages;

    messages = _message_table[thisnode];

    foreach (messages)
    {
	if (time_after (*fromtime, messages->msg->arrived))
	    continue;

	if (totime isnt nil and time_before (*totime, messages->msg->arrived))
	    break;

	return (&messages->msg->arrived);
    }

    return (nil);
}

_reschedule (nodeid, arrivedtime)
ident           nodeid;
timev           arrivedtime;

{
    process 	this_proc, recv_proc;

D(printf("reschedule: this node %d, scheduled node %d, arrivedtime %d,%d\n", _current_node, nodeid, arrivedtime.tv_sec, arrivedtime.tv_usec);)

    this_proc = _proc_table[_current_node];
    recv_proc = _proc_table[nodeid];
   
    /* If the receiver hasn't already got a message, it is in
     * the blocked queue. Otherwise, it is in the wait queue, 
     * either before or after the arrivedtime . Special case
     * where we are rescheduling the current node, and we have
     * to remove the current activation record.
     */

    if (time_iszero (recv_proc.unblocked))
    {
        _remove_sched (nodeid, BlockedQueue);
        _proc_table[nodeid].unblocked = arrivedtime;
        _sched_table[nodeid].unblocked = arrivedtime;
        _insert_sched (nodeid);
	return;
    }

    if (time_before (arrivedtime, recv_proc.unblocked))
    {
        _remove_sched (nodeid, WaitQueue);
        _proc_table[nodeid].unblocked = arrivedtime;
        _sched_table[nodeid].unblocked = arrivedtime;
        _insert_sched (nodeid);
	return;
    }
	
    /* if we are here, then the node isnt blocked, and the
     * unblocked time is earlier than the current message's
     * arrived time. If we are rescheduling a node different
     * from _current_node, then we have nothing more to do.
     * If we are rescheduling _current_node, then the message
     * has already been inserted into the message list, and on
     * a recvm(), the correct unblock time will automatically
     * be inserted into the list. So we are done.
     */

    D(printf("arrived time %d, %d, later than unblocked time %d, %d..returning\n", arrivedtime.tv_sec, arrivedtime.tv_usec, recv_proc.unblocked.tv_sec, recv_proc.unblocked.tv_usec);)

}

ident
recvm (destp, keyp, dataptrp)		/* returns sending node */
    ident          *destp;	/* gets dest of initial sendm() call */
    long           *keyp;	/* gets message code (user defined) */
    char          **dataptrp;	/* gets ptr to message data on heap */
{
    ident           sender;
    register message *msg_ptr;


    if (_message_table[_current_node] is nil)
    {				/* block indefinitely if no messages */
	if (_block (time_zero, RECEIVE))
	    fatal ("recvm: block(0): ");
    }

    msg_ptr = _message_table[_current_node]->msg;

    if (time_after (msg_ptr->arrived, _proc_table[_current_node].runtime))
    {				/* block until that message arrives */
	if (_block (msg_ptr->arrived, RECEIVE))
	    fatal ("recvm: block(1): ");
    } else
    {				/* block until present time */
	if (_block (_proc_table[_current_node].runtime, RECEIVE))
	    fatal ("recvm: block(2): ");
    } 

    /* get the first message which arrives (it may have changed) */

    msg_ptr = _message_table[_current_node]->msg;

    /* we reach here only if a message exists, and has arrived already */

    /* set up recvm's argument variables */

    sender = msg_ptr->sender;	/* temporary value for return() */

    *destp = msg_ptr->dest;

    *keyp = msg_ptr->key;

    *dataptrp = msg_ptr->dataptr;

    /* remove the message from the message list */

    _drop_message (&_message_table[_current_node]);

    return (sender);		/* return the message's sender */
}
