/*
 * Nest simulation library - error message routines
 * 
 * $Header: errors.c,v 2.5 88/03/31 14:49:09 dupuy Rel $
 */

#include "nest.h"

#include "defs.h"
#include "simulate.h"

static char     errbuffer[256];         /* buffer for error messages */
static int      errindex = 254;         /* pointer to start of mess. */


_error (errmessage)
char           *errmessage;
{
    register int    length;
    extern char    *strncpy ();

    if (errindex > (length = strlen (errmessage)))
        (void) strncpy (&errbuffer[errindex -= length], errmessage, length);
    return (Error);
}


_complain (errmessage)
char           *errmessage;
{
    extern int      errno;
    extern char    *sys_errlist[];

    errbuffer[255] = '\0';
    errbuffer[254] = '\n';

    (void) _error (errmessage);

    (void) fprintf (stderr, &errbuffer[errindex], sys_errlist[errno]);

    errindex = 254;

    return (Error);
}
