/*
 * Style definitions - useful macros and such
 * 
 * $Header: defs.h,v 2.5 88/03/31 14:49:07 dupuy Rel $
 */

/*
 * Human readable replacements for obscure typographical marks
 */

#define and     &&
#define or      ||
#define is      ==
#define isnt    !=
#define not     !

/*
 * Flow of control structures
 */

#define where               break; case
#define when(cond)          ((cond) ?   /* macros require parentheses as are */
/* *    (                                 indicated here in comments on left */
#define     then(exp)         (exp))
#define     otherwise(exp)   :(exp)
/* *    )                                                                    */

#define until(cond)         while(not(cond))
#define foreach(ptr)        for(; ptr isnt nil; nextn(ptr))
#define ever                ;;

/*
 * Define simple types which are used everywhere
 */

#define reg register

#define bool    boolean                 /* common names for booleans */
#define flag    boolean
#define false   0                       /* standard C values */
#define true    1

typedef char   *string;                 /* real string pointer */
typedef char   *pointer;                /* generic pointer to a location */
typedef int     (*funcptr) ();          /* generic pointer to a function */

#define nil     0                       /* should be same as stdio NULL */

/*
 * Define linked list data structures, and manipulation macros
 */

typedef struct list *ptr;
typedef struct list **list;
typedef struct list                     /* skeleton for singly linked list */
{
    struct list    *next;               /* pointer to next item on list */
} item;

/*
 * The basic macros (should be part of C :-)
 */

#define max(a,b)        (((a)>(b)) ? (a) : (b))
#define min(a,b)        (((a)<(b)) ? (a) : (b))
#define new(thing)      ((thing *) malloc (sizeof (thing)))
#define newarray(number, thing) \
                        ((thing *) calloc ((unsigned) number, sizeof (thing)))
#define dispose(item)           (free ((pointer) (item)))
#define dispose_list(ptr)       foreach (ptr) dispose (ptr)

#define copystring(ptr)         strcpy (malloc(1+(unsigned) strlen (ptr)), ptr)

/*
 * Nifty pointer manipulation stuff for lists (queues have insque/remque)
 */

/* set pointer to next item on list */
#define nextn(ptr)              ((ptr) = (ptr)->next)

/* same as nextn, with pointer name */
#define nextf(ptr, field)       ((ptr) = (ptr)->field)

/* insert node at start of list */
#define insn(ptr, list)         ((ptr)->next = *(list), *(list) = (ptr))

/* same as insn, with pointer name */
#define insf(ptr, list, field)  ((ptr)->field = *(list), *(list) = (ptr))

/* set list pointer to next list link */
#define advancn(list)           ((list) = &(*(list))->next)

/* same as advancn, with pointer name */
#define advancf(list, field)    ((list) = &(*(list))->field)

/* add node to end of list, advance */
#define addn(list, ptr)         (*(list) = (ptr), (list) = &(ptr)->next)

/* same as addn, with pointer name */
#define addf(list, ptr, field)  (*(list) = (ptr), (list) = &(ptr)->field)

/* drop node from list, dispose */
#define dropn(list)             (dispose(*(list)), *(list) = (*(list))->next)

/* same as dropn, with pointer name */
#define dropf(list, field)      (dispose(*(list)), *(list) = (*(list))->field)

/* cons a new entry on list, advance list and ptr */
#define chain(list, ptr, thing) (list = &ptr->next, *list = ptr = new (thing))
