/*
 * Nest simulation library - time definitions for berkeley timeval structures
 * 
 * $Header: dcctime.h,v 2.5 88/03/31 20:41:19 dupuy Rel $
 */

#ifndef dcctime
#define dcctime

#include <sys/types.h>                  /* get time_t */

#ifndef CANBSIZ
#include <sys/param.h>                  /* get HZ, maybe */
#endif

#include <sys/times.h>                  /* get struct tms */

/*
 * Define time types
 */

typedef struct timeval timev;           /* time in seconds, microseconds */
typedef struct itimerval itimer;        /* system timer interval, value */

extern struct timeval hztime ();        /* convert time in ticks to timeval */
/*
 * Define time operations (tests work correctly only on normalized timevals)
 */

#define time_iszero(tv)    (!time_nonzero(tv))
#define time_nonzero(tv)   ((tv).tv_sec || (tv).tv_usec)
#define time_equal(tv1,tv2) \
    ((tv1).tv_sec == (tv2).tv_sec && (tv1).tv_usec == (tv2).tv_usec)
#define time_after(tv1,tv2) \
    ((tv1).tv_sec > (tv2).tv_sec \
     || ((tv1).tv_sec == (tv2).tv_sec && (tv1).tv_usec > (tv2).tv_usec))
#define time_before(tv1,tv2) \
    ((tv1).tv_sec < (tv2).tv_sec \
     || ((tv1).tv_sec == (tv2).tv_sec && (tv1).tv_usec < (tv2).tv_usec))
#define time_positive(tv) \
    ((tv).tv_sec > 0 || ((tv).tv_sec == 0 && (tv).tv_usec > 0))
#define time_negative(tv) \
    ((tv).tv_sec < 0 || ((tv).tv_sec == 0 && (tv).tv_usec < 0))

#define time_clear(tv)  ((tv).tv_sec = (tv).tv_usec = 0)
#define time_normalize(tv) \
    ((tv).tv_sec += (tv).tv_usec / MILLION, \
     (((tv).tv_usec %= MILLION) < 0) ? \
     --(tv).tv_sec, (tv).tv_usec += MILLION, (tv) : (tv))

#define time_plus(tv1,tv2) \
    (time_result.tv_sec = (tv1).tv_sec + (tv2).tv_sec, \
     time_result.tv_usec = (tv1).tv_usec + (tv2).tv_usec, time_result)
#define time_minus(tv1,tv2) \
    (time_result.tv_sec = (tv1).tv_sec - (tv2).tv_sec, \
     time_result.tv_usec = (tv1).tv_usec - (tv2).tv_usec, time_result)

#define time_add(tv1,tv2) \
    {(tv1).tv_sec += (tv2).tv_sec + \
     ((tv1).tv_usec += (tv2).tv_usec) / MILLION; \
     if (((tv1).tv_usec %= MILLION) < 0) \
     {--(tv1).tv_sec; (tv1).tv_usec += MILLION;}}
#define time_sub(tv1,tv2) \
    {(tv1).tv_sec -= (tv2).tv_sec - \
     ((tv1).tv_usec -= (tv2).tv_usec) / MILLION; \
     if (((tv1).tv_usec %= MILLION) < 0) \
     {--(tv1).tv_sec; (tv1).tv_usec += MILLION;}}
#define time_elapsed_add(tv1,tv2,tv3) \
    {(tv1).tv_sec += (tv2).tv_sec - (tv3).tv_sec + \
     ((tv1).tv_usec += (tv2).tv_usec - (tv3).tv_usec) / MILLION; \
     if (((tv1).tv_usec %= MILLION) < 0) \
     {--(tv1).tv_sec; (tv1).tv_usec += MILLION;}}


#define MILLION 1000000L

extern timev    atotv ();

/*
 * Define global time variables
 */

extern timev    time_zero;              /* should be readonly */
extern timev    time_result;            /* temporary timev variable */

#endif                                  /* dcctime */
