/*
 * Nest simulation library - berkeley compatibility functions
 * 
 * $Header: compat.c,v 2.5 88/03/31 21:24:40 dupuy Rel $
 */

#include "nest.h"
/* #include "dccsig.h"*/
#include "defs.h"

int             _compatible;            /* so the symbol table isn't empty */

#ifndef BSTRING

#ifdef MEMSET
#include <memory.h>

bcopy (s2, s1, l)
char           *s2;
char           *s1;
unsigned        l;
{
    (void) memcpy (s1, s2, l);
}

bzero (s1, l)
char           *s1;
unsigned        l;
{
    (void) memset (s1, 0, l);
}

#else

bcopy (s2, s1, l)
char           *s2;
char           *s1;
int		l;
{
    while (--l >= 0)
        *s1++ = *s2++;
}

bzero (s1, l)
char           *s1;
int		l;
{
    while (--l >= 0)
        *s1++ = 0;
}

#endif                                  /* !MEMSET */
#endif                                  /* !BSTRING */

ffs (i)
int             i;
{
    int             bit = 0;

    while (i isnt 0)
    {
        bit++;
        if (i & 1)
            break;
        i >>= 1;
    }

    return (bit);
}

