case $CONFIG in
'')
    if test ! -f config.sh; then
	(echo "Can't find config.sh."; exit 1)
    fi
    . config.sh
    ;;
esac
: This forces SH files to create target in same directory as SH file.
: This is so that make depend always knows where to find SH derivatives.
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac
echo "Extracting Makefile (with variable substitutions)"
cat >Makefile <<!GROK!THIS!
#
# Makefile for Nest 2.5 (modified)
#
# This Makefile is generated by Configure from Makefile.SH.  Feel free to
# modify this Makefile; however, any changes made will be lost the next time
# you run Configure.  For more permanent changes, edit Makefile.SH instead.
# 
# If you are running a system that only supports shared objects 
# (such as IRIX > 5.2, you will need to uncomment the line in target 'all'
# For Solaris, I recommend using -a -dn flags, which avoids shared
# objects

# Configuration options

INC = $inc
LIB = $lib
LLIB = $lintlib

DEFS =
CPPFLAGS = $(DEFS) 
OPTFLAGS = -g -D_BSD_SIGNALS $d_cckr -c


# Standard Make variables

SHELL = /bin/sh

CC = cc
CFLAGS = \$(OPTFLAGS)

LINT = lint
LINTFLAGS = -buxz

CPP = $cpp $cppminus
AS = as

LD = ld
LDFLAGS =
LIBS = 

RANLIB = $ranlib
!GROK!THIS!

if $test -f /usr/include/make/default.mk
then
cat >>Makefile <<'!NO!SUBS!'

# File groups

!NO!SUBS!
else
cat >>Makefile <<'!NO!SUBS!'

CFLAGS = $(OPTFLAGS) $(CPPFLAGS) 

# Additional rules for assembler source files

.SUFFIXES: .S

.S.o:
	#$(CPP) $(CPPFLAGS) < $< | grep -v '^#' > $*.s
	$(AS) $(ASFLAGS) $(TARGET_ARCH) -o $@ $*.s
	@rm -f $*.s

# File groups

!NO!SUBS!
fi


cat >>Makefile <<'!NO!SUBS!'

# File groups

public = dcctime.h nest.h graph.h

headers = defs.h dccsig.h simulate.h process.h schedule.h \
	  message.h network.h state.h swap.h

csource = simulate.c server.c store.c swap.c\
	  network.c schedule.c errors.c 

asource = state.S

nestobj = simulate.o server.o store.o swap.o \
	  network.o schedule.o errors.o state.o

functns = nestargs.c ipc.c utils.c compat.c

funcobj = nestargs.o ipc.o utils.o compat.o

lib = nest.a

lintlib = llib-lnest.ln

addedbyconf = UU Makefile Makefile.bak makelib makedepend kit*isdone all \
	 config.h nest.h 

.PRECIOUS: $(lib)


all: $(public) $(lib) 
	touch all
# uncomment this line for SGI IRIX version >= 5.2, comment for all others
# must comment for solaris
#	ld -shared -all nest.a -o nest.so


# Build nest library with makelib

nest.a:	$(funcobj) makelib $(nestobj)
	makelib rc nest.a $(funcobj) $(nestobj)

# Build lint library

llib-lnest.ln: $(public) $(headers) $(csource) $(functns)
	$(LINT) -Cnest $(CPPFLAGS) $(csource) $(functns)

clean:
	rm -f *.o core core.* errs

realclean:
	rm -rf *.o core core.* errs $(addedbyconf) $(example) $(lib) $(lintlib)

lint:
	$(LINT) $(LINTFLAGS) $(CPPFLAGS) $(csource) $(functns)

listing: $(public) $(headers) $(csource) $(asource) $(functns) callgraph
	enscript -2r -F Helvetica-Bold10 -f Courier7 \
	$(public) $(headers) $(csource) $(asource) $(functns)
	enscript -r -F Helvetica-Bold10 -f Courier7 callgraph

callgraph: $(public) $(headers) $(csource) $(functns)
	cflow -i_ $(csource) $(functns) > callgraph

tags:	$(public) $(headers) $(csource) $(functns)
	ctags -t $(csource) $(functns)
	etags -et $(csource) $(functns)

depend: $(csource) $(functns) makedepend 
	./makedepend $(csource) $(functns) > depends
	echo '/^# DO NOT DELETE THIS LINE/+2,$$d' >eddep
	echo '$$r depends' >>eddep
	echo 'w' >>eddep
	cp Makefile Makefile.bak
	ed - Makefile < eddep
	rm -f eddep depends
	echo '' >> Makefile
	echo '# DEPENDENCIES MUST END AT END OF FILE' >> Makefile
	echo '# IF YOU PUT STUFF HERE IT WILL GO AWAY' >> Makefile
	echo '# see make depend above' >> Makefile

# DO NOT DELETE THIS LINE -- make depend uses it


# DEPENDENCIES MUST END AT END OF FILE
# IF YOU PUT STUFF HERE IT WILL GO AWAY
# see make depend above



!NO!SUBS!
