/*
 * ARGS USED: average rate
 * NOT USED : peak_rate, on_time, off_time, interval
 *
 * Generic telnet source with flow control. Code modified by S. McCanne, LBL
 */

#include "../kernel/real.h"

#define MWS MAX_WINDOW_SIZE
#define RECOVERY_STATE 1 	/* the source is retransmitting lost packets */
#define NORMAL_STATE 0 		/* otherwise */

telnet()

/* no window adjustment or timeout deviation estimation */

{
    /* Misc. variables */
    PKT_PTR         pkt, deq_pkt, tick_pkt = (PKT_PTR) 0;
    int             num, node, line_busy = 0, sleeping = 0;
    ident           destn, sender, sink;
    long            key;
    timev           now, gen, diff;
    float           delay, err, timeout, tao;
    int             i, last;

    /* state variables */
    timev           time_sent[MWS];
    float           rtt ;
    int             last_sent, last_ack, seq_no, min_window;

    int             telnet_state; 	/* either normal or recovery */
    int             recovery_can_send;
    		/* flag used to allow only one pkt to be sent after a timeout */
    /*
     * once this happens, either the retx. pkt must timeout again, or the
     * retx. pkt should acked, which will reset the flag
     */

    int             timer_id = 1;
    int             max_window;
    float	    beta_rtt = 2.0;

    /* dont let any simulation time pass while the node executes */


    node = get_node_id();
    sink = assigned_sink[node];
    abs_advance(node_start_time[node]);
    max_window = telnet_window;

    printf("Telnet source: %d ", get_node_id());
    printf("sending to sink %d\n", sink);

    source_node_type[node] = TELNET_SOURCE;

    last_sent = last_ack = -1;
    rtt = 6.0 * scale_factor;
    timeout = beta_rtt * rtt;
    seq_no = 0;
    alpha_rtt_telnet = (float) (1 / (float) 10.0);

    recovery_can_send = 0;
    telnet_state = NORMAL_STATE;

    /* pretend that you got  an INT pkt, go to test */

    make_pkt(pkt);
    pkt->type = DATA;
    pkt->resent = 0;
    pkt->seq_no = seq_no++;
    enq(node, pkt);

    goto test;

    for (ever)
    {
	/* point where data is received */
recv:
	sender = recvm(&destn, &key, &pkt);
	now = runtime();

	switch (pkt->type)
	{

	case ACK:
	    {
		if (pkt->seq_no is last_sent)
		    telnet_state = NORMAL_STATE;

		/* clean up queue -- i.e. remove all acked packets */

		num = num_in_q(node);
		while (num-- > 0)
		{
		    deq_pkt = deq(node);
		    if (deq_pkt->seq_no > last_ack)
			enq(node, deq_pkt);
		    else
			free(deq_pkt);
		}

		/* last_ack is the highest seq_no that has been acked */
		if (pkt->seq_no > last_ack)
		{
		    /* ack not seen before */
		    last = last_ack;

		    /* it might be an ack for more than one packet */
		    for (i = 1; i <= pkt->seq_no - last; i++)
		    {
			diff = time_minus(now, time_sent[(last_ack + i) % MWS]);
			tao = make_float(diff);
			rtt = rtt + alpha_rtt_telnet * (tao - rtt);
			timeout = beta_rtt * rtt;
			make_entry(tao, &rt_time[node]);
		    }
		    /* update state */
		    last_ack = pkt->seq_no;
		    recovery_can_send = 1;
		}
		/* get rid of the ack packet */
		free(pkt);
		goto test;
	    }
	case WAKEUP:
	    /* the source is ready to send */
	    tick_pkt = pkt;
	    sleeping = 0;
	    make_pkt(pkt);
	    pkt->type = DATA;
	    pkt->resent = 0;
	    pkt->seq_no = seq_no++;
	    enq(node, pkt);
	    goto test;

	case INT:
	    /* line is now free */
	    line_busy = 0;
	    free(pkt);
	    goto test;

	case TIMEOUT:
	    /* may have been acked , simulate single timer */
	    if (timer_id is pkt->id and pkt->seq_no > last_ack)
	    {
		telnet_state = RECOVERY_STATE;
		recovery_can_send = 1;
		pkt->type = DATA;
		pkt->seq_no = last_ack + 1;

		/* backoff */
		diff = time_minus(now, pkt->gen_time);
		timeout = 2.0 * make_float(diff);
		pkt->gen_time = runtime();
		pkt->resent = 1;
		enq(node, pkt);
	    } else
		/* dump pkt */
		free(pkt);
	    goto test;
	default:
	    free(pkt);
	    pr_error("Node %d recvd. a pkt of unknown type", node);
	}
test:
	pkt = deq(node);
	if (pkt isnt (PKT_PTR) 0)
	{
	    if (((telnet_state is NORMAL_STATE and
		    pkt->seq_no <= last_ack + max_window)
		or (telnet_state is RECOVERY_STATE and recovery_can_send))
		and !sleeping and !line_busy and pkt isnt NULL)
	    {
		line_busy = 1;
		sleeping = 1;
		time_sent[pkt->seq_no % MWS] = runtime();
		pkt->id = ++timer_id;
		pkt->gen_time = runtime();
		if (pkt->resent)
		    num_retransmissions[node]++;
		if (pkt->seq_no > last_sent)
		    last_sent = pkt->seq_no;
		safe_send(pkt, timeout);
		recovery_can_send = 0;

		/* set sleep time */

		delay = (float) (expntl(((float) telnet_size * 8.0)
						 / ave_bandwidth[node]));

		if (tick_pkt is (PKT_PTR) 0)	/* start up */
		{
		    make_pkt(tick_pkt);
		    tick_pkt->type = WAKEUP;
		}
		set_timer(delay, tick_pkt);
	    }
	    else
		enq(node, pkt);
	}
	goto recv;
    }
}
