/*
 * Sink receives data from sources. For guaranteed service packets, it
 * does not send any acks. For Best effort packets, it sends an ack with
 * the sequence number set to the last in-sequence packet seen so far 
 *
 * There is a hidden assumption that the output line is never busy
 */

extern int      SI_DEBUG ;

#include "../kernel/real.h"

extern RECV_PTR find_recv_str();
extern RECV_PTR add_recv_str();
extern RECV_PTR make_recv_str();

sink ()
{
    PKT_PTR         pkt;
    int             i, j, source, conv_id;
    ident           destn, node, sender;
    long            key;
    RECV_PTR	    head_recv_queue = 0; /* ptr to list of recv_type strs. */
    RECV_PTR	    rcv_conv;
    timev           now, diff;
    char            fname[20];
		

    node = get_node_id ();
    source_node_type[node] = SINK;
    printf ("Sink : %d\n", node);

    for (ever)
    {
recv:
	sender = recvm (&destn, &key, &pkt);
	now = runtime ();

	switch (pkt->type)
	{
	case DATA:
	    source = pkt->source;
	    conv_id = hash (node, source, pkt->dest);

	    /* dump end to end delay */
	    if(pkt->trace)
	    {
		diff = time_minus(now, pkt->gen_time);
	     	sprintf(fname, "e2e.%d.", source);
	    	make_flt_plot(fname, make_float(diff));
	     }

	    if (pkt->gs)
	    {
		free (pkt); 	/* no ack for gs source */
		goto recv;
	    }
	    else
	    {
	        rcv_conv =  find_recv_str(conv_id, head_recv_queue);
		if(!rcv_conv) 
			rcv_conv = add_recv_str(conv_id, &head_recv_queue);
		if (pkt->seq_no > rcv_conv->last_in_seq)
		    /* setting the sequence number - should be the last in
		     * sequence packet seen */
		{
		    int             ack, window;

		    window = MAX_WINDOW_SIZE;
		    rcv_conv->seen[pkt->seq_no % window] = 1;
		    ack = rcv_conv->last_in_seq;
		    while (rcv_conv->seen[(ack + 1) % window])
		    {
			ack++;
			rcv_conv->seen[ack % window] = 0;
		    }
		    rcv_conv->last_in_seq = ack;
		    if (SI_DEBUG)
			printf ("(%d,%d):Sink sent an ack seq # %d\n", 	
					now.tv_sec, now.tv_usec, ack);
		}

		/* send an ack by changing the packet's params */

		if((pkt->seq_no - rcv_conv->last_in_seq) > 0)
		    pkt->last_recvd_offset = pkt->seq_no - rcv_conv->last_in_seq;
		else
		    pkt->last_recvd_offset = 0;
		pkt->seq_no = rcv_conv->last_in_seq;
		pkt->type = ACK;
		pkt->size = ack_size;	
		pkt->trace = 0;
		pkt->source = node;
		pkt->dest = source;	/* a global id */
		pkt -> trace = 0;
		if (!sendm (route[_current_node][pkt->dest], 0, (char *) pkt))
			pr_error ("sendm failed in sink");
	    }
	    break;

	case SETUP:
	    {
		pkt->dest = pkt->source;
		pkt->source = node;
		pkt->type = SETUP_ACK;
		pkt->size =  ack_size;	
		pkt->gs = 0;	/* ACKS are not set up, so BE */
		sendm (route[node][pkt->dest], 0, (char *) pkt);

	    } break;
	default:
	    free (pkt);
	}
    }
}

RECV_PTR
make_recv_str(conv_id)
int conv_id;
{
    RECV_PTR tmp;

    tmp = (RECV_PTR) calloc((unsigned)sizeof(RECV), 1);
    tmp->conv_id = conv_id;
    tmp->next = (RECV_PTR) 0;
    return tmp;
}

RECV_PTR
add_recv_str(conv_id, ptr_head_recv_queue)
int conv_id;
RECV_PTR *ptr_head_recv_queue;
{
    RECV_PTR tmp;

    if(!(*ptr_head_recv_queue))
    {
	*ptr_head_recv_queue = make_recv_str(conv_id);
        return *ptr_head_recv_queue;
    }
	
    tmp = make_recv_str(conv_id);
    tmp->next = *ptr_head_recv_queue;
    (*ptr_head_recv_queue) = tmp;
  
    return tmp;
}

RECV_PTR
find_recv_str(conv_id, head_recv_queue)
RECV_PTR head_recv_queue;
int conv_id;
{
    RECV_PTR tmp;

    for(tmp = head_recv_queue; tmp; tmp = tmp->next)
    {
        if(tmp->conv_id is conv_id) 
	    return tmp;
    }
    return (RECV_PTR) 0;
}
