#include "../kernel/real.h"

send_pkt (pkt)
PKT_PTR pkt;
{
    int node, dest;
    node = get_node_id ();

    dest = pkt->dest;

    if (route[node][dest] is 0) {
	printf("node %d, dest %d, route[node][dest] %d\n",
		node, dest, route[node][dest]);
        pr_error ("Routing error in node");
    }

    if (not sendm (route[node][dest], 0, (char *) pkt))
        pr_error ("Node %d send: message undeliverable ", node);

    make_plot ("seq", pkt->seq_no);
}

safe_send (pkt, timeout)
PKT_PTR pkt;
float timeout;

{
    /* sends a packet safely i.e. with an associated timeout */

    PKT_PTR	    timeout_pkt;
    ident           dest;
    ident           node;

    node = get_node_id ();

    dest = pkt->dest;

    /* largest possible long number limits us this magic number is
     * guaranteed to not overflow ... */

    timeout_pkt = (PKT_PTR) malloc ((unsigned) sizeof (PKT));
    *timeout_pkt = *pkt;
    timeout_pkt -> type = TIMEOUT;

    set_timer(timeout, timeout_pkt);

    if (route[node][dest] == 0) 
        pr_error ("Routing error in node");
    if (sendm (route[node][dest], 0, (char *) pkt) isnt 1)
        pr_error ("safe_send: message undeliverable ", pkt);

    make_plot ("seq", pkt->seq_no);
}
