/*
 * ARGS USED: average rate, peak rate
 * NOT USED : on_time, off_time, interval
 *
 * random_rate sends data at the average rate specified, 
 * and no faster than the peak rate. 
 *
 * Unlike background.c, random_rate performs call setup 
 * at the beginning of the simulation. It does not
 * allow sending phase shifts like background.c
 * 
 * on_time, off_time and interval are not used 
 */


#include "../kernel/real.h"

extern int	CONT_DEBUG;

random_rate()
{
    PKT_PTR         pkt, tick_pkt = (PKT_PTR)0;
    int             num, node, seq_no = 0, pkts_sent = 0;
    int             start_up = 1, line_busy = 0, tick = 0;
    ident           destn, sender, sink;
    long            key;
    float	    delay, delaymin, delaymax;
    timev           now;

    node = get_node_id();
    source_node_type[node] = RANDOM_RATE_SOURCE;
    sink = assigned_sink[node];
    abs_advance(node_start_time[node]);

    printf("Random rate source: %d ", get_node_id());
    printf("--> %d, start (%d, %d), average rate %f\n",
	   sink, node_start_time[node].tv_sec,
	   node_start_time[node].tv_usec,
	   ave_bandwidth[node]);

     if(ave_bandwidth[node] > peak_bandwidth[node])
	pr_error("average bandwidth more than peak bandwidth!");

    /* call setup */

    make_pkt(pkt);
    pkt->seq_no = seq_no ++;
    pkt->gen_time = runtime();
    pkt->type = SETUP;
    pkt->ave_bandwidth = ave_bandwidth[node];
    pkt->peak_bandwidth = peak_bandwidth[node];
    pkt->interval = interval[node];
    pkt->jitter = jitter[node];
    pkt->class = class[node];
    pkt->gs = 0;	     /* setup packet is not GS */

    send_pkt(pkt);

    for (ever)
    {
recv:
	sender = recvm(&destn, &key, &pkt);
	now = runtime();

	switch (pkt->type)
	{
	case SETUP_ACK:
	    if (pkt->ave_bandwidth is 0.0)	/* refused ! */
	    {
		printf("node %d refused, not enough bandwith \n", node);
		goto recv;
	    } else if (pkt->peak_bandwidth is 0.0)
	    {
		printf("node %d refused, not enough buffer \n", node);
		goto recv;
	    }
            printf("node %d: connection ok, starting\n",node);
	    tick = 1;
	    goto test;
	case ACK:
	    free(pkt);
	    goto recv;
	case INT:
	    line_busy = 0;
	    free(pkt);
	    goto test;
	case TIMER:
	    tick = 1;
            tick_pkt = pkt;
	    goto test;
	default:
	    free(pkt);
            pr_error("Node %d: source received a pkt of unknown type", node);
	}
    }

test:

    if (tick and (not line_busy) and pkts_sent < num_pkts[node])
    {
	tick = 0;
	line_busy = 1;

	make_pkt(pkt);
	pkt->seq_no = seq_no ++;
	pkt->gen_time = runtime();
	pkt->gs = 1;
	pkts_sent ++;
	send_pkt(pkt);
	
	/* schedule next tick */

	delaymin = ((float) ftp_size *8.0/peak_bandwidth[node]);
	delaymax = ((float) 2*ftp_size *8.0/ave_bandwidth[node]) - delaymin;
	delay = delaymin + RANDOM * (delaymax - delaymin);


        if(tick_pkt is (PKT_PTR)0)      /* start up */
        {
            make_pkt(tick_pkt);
            tick_pkt -> type = TIMER;
        }

	set_timer(delay, tick_pkt);
    }
    goto recv;
}
