/*
 * Packet pair  with control theoretic flow control
 */

/* Revision history */

/* 5/12/94: fixed B probing, and probing parameters */
/* 5/16/94: sink now sends ack_for as well as seq_no - changed retx code */
/* 5/18/94: added PP_TRANS changes to test */
/*
 * 5/20/94: debugged PP_TRANS - num_out, use of last_sent instead of
 * pkts_sent added last_ack heuristic for lost retxs
 */
/* 10/9/95: added detection of lost acks and lost acks of retransmissions */
/* 10/11/95: debugged startup case */
/* 8/13/97: rolled in all changes to pp into a single file and commented */

extern int      PP_PRINT;
extern int      BIG_CTH_DEBUG;

#include "../kernel/real.h"
/* If PP_TRANS is defined, then this node will act as a transport layer.
 * Specifically, it will wait for packets to arrive from another node
 * 'app_node', and will send that node a message when the transmit 
 * queue is empty and all the preceding data has been RELIABLY sent -- i.e
 * sent and acked. The app node indicates end of transmission with a 
 * special packet. Currently, the onoff, onoff_closed, and onoff_closed_gbn
 * sources are candidates for app nodes. 
*/
/* #define PP_TRANS */

/* If NO_FLOW_CONTROL is defined, then this node will do only error
 * control, and no flow control. In other words, the node will 
 * send packets as soon as they arrive, and will not regulate the
 * flow of packets. However, lost packets will be correcly retransmitted
 */

/* #define NO_FLOW_CONTROL */

/* By a suitable choice of #defines, this node can be made to look
 * like a transport layer that provides both error and flow control,
 * or only error control. ALso, it can be asked to simulate an infinite
 * stream that always has packets to send, or can send packets as they
 * arrive from an app node. 
 */

/* the next line is for debugging */
#define D(x) 

extern float    compute_alpha();

/* tuning parameters */

#define ATTACK_UP       1.5  /* attack rate if bottleneck less full */
#define ATTACK_DOWN     0.8  /* attack rate if bottleneck less full */
#define TIMEOUT_MULTIPLIER 1.5	/* this times RTT est. is timeout value */
#define SINGLETON_TIMEOUT 0.100	/* if no pair in 100 ms, send out
				 * singleton */
#define INITIAL_TIMEOUT  1.0 /* initial timeout value in seconds */

#define INC_FACTOR 	0.2  /* factor controlling send rate increase */
#define MS_ALPHA        0.75 /* exp. av. const. for mean_send_rate */

#define B_DEC_FACTOR	0.75 /* multiplicative decrease factor */
#define B_ADD_INC_FACTOR 2.0 /* additive increase for setpoint probe */
#define B_INITIAL	5    /* initial value of B */
#define B_MIN		2.0  /* smallest value */
#define B_COUNT		2    /* how many rtts to wait before changing B */


#define ceil(x) (int)((x) + 1)

#define MWS MAX_WINDOW_SIZE

int             num_retx[MAX_NODES + 1][MWS];	/* number of times seq #
						 * retx */
int             recvd_ok[MAX_NODES + 1][MWS];	/* this seq. no recvd ok */

/* these are globals, since each time the node is run the stack is swapped */

#ifdef NO_FLOW_CONTROL
pp_reg()
#else
pp()
#endif
{
    PKT_PTR         deq_pkt; /* pkt dequeued from tx queue */
    PKT_PTR         pkt;     /* pkt under consideration */
    PKT_PTR         retx_pkt;/* pkt to be retransmitted */
    PKT_PTR         sing_pkt;/* timer pkt for catching singletons */
    int             node;    /* ID of current node */
    int             seq_no = 0;	/* sequence number counter */
    int             last_sent = -1;	/* highest seq no sent so far */
    int             ack_adjust = -1;	/* lowest pt. in seq. space where
					 * num_out adjusted for missing
					 * acks */
    int             num_outstanding = 0;	/* number of packets
						 * outstanding */
    int             start_up = 1;	/* flag indicating startup */
    int             line_busy = 0;	/* flag indicating output line
					 * byust */
    int             tick = 2;/* how many packets to send to probe */
    int             num_timeouts = 0;	/* # timeouts seen so far */
    timev           now;     /* time now */
    timev           time_of_last_ack;	/* time when last ack recvd */
    float           timeout; /* timeout value */
    float           alpha;   /* exp. av. const for rate estimate */
    float           nbhat = 0;	/* estimate of # pkts in bottlneck */
    float           se;	     /* bottleneck rate estimator ^-1 */
    float           re;	     /* estimator of RTT */
    float           reclean; /* clean estimate of prop. delay */
    float           send_rate;	/* computed sending rate */
    float           old_send_rate = 0.0;	/* old sending rate */
    float           mean_send_rate = 0.0;	/* smoothed sending tate */
    float           inter_ack;	/* current value */
    int             last_ack = -1;	/* last ack seen so far */
    int             cum_ack = -1;	/* cumulative ack in current pkt */
    int             fast_retx_count = 0;	/* counts number of fast
						 * retxs sent */
    int             first_of_pair = -1;	/* seq # of first ack of pair */
    int             transmission_id = 0;	/* unique id incremented
						 * every pkt. */
    int             dup_ack_retx = 0;	/* # retx. pkt due to dup ack */
    int             total_dup_acks = 0;	/* # pkts retx.ed so far from
					 * dupacks */
    float           B = B_INITIAL;	/* setpoint */
    int             rtt_seq = 0;	/* if ack > rtt_seq, >= 1 RTT has
					 * elapsed */
    int             rtt_count = 0;	/* how many rtts have gone by */
    char            no_more_data = 0;	/* true if app says theres no more
					 * data */
    int             app_node = 0;	/* node number of application
					 * layer */

    int             i, num;  /* scratch variables */
    ident           destn, sender, sink;	/* scratch variables */
    timev           diff;    /* scratch */
    float           tao;     /* scratch */
    long            key;     /* scratch variables */

    node = get_node_id();
    abs_advance(node_start_time[node]);
    sink = assigned_sink[node];
    printf("pp source: %d ", get_node_id());
    printf("sending %d packets to sink %d\n", num_pkts[node], sink);
    source_node_type[node] = PP_SOURCE;

    for (i = 0; i < MAX_WINDOW_SIZE; i++) {
	num_retx[node][i] = 0;
	recvd_ok[node][i] = 0;
    }
    last_ack = -1;
    time_of_last_ack = runtime();
    timeout = INITIAL_TIMEOUT * scale_factor;
#ifdef NO_FLOW_CONTROL
    tick = 1;
#else
    tick = 2;
#endif
    line_busy = 0;
    goto test;

    for (ever) {

recv:
	sender = recvm(&destn, &key, &pkt);
	now = runtime();
	    D(printf("\n%f: node %d recvd. packet seq %d, resent %d last_ack %d  type %s, decbit %d\n", make_float(now), node, pkt->seq_no, pkt->resent, last_ack, type_to_str(pkt->type), pkt->decbit);)

	switch (pkt->type) {

	case ACK:
	    if (PP_PRINT){
		make_plot("ack", pkt->seq_no);
		make_plot("num_out", num_outstanding);
	    }

	    /* since at least one packet reached the sink */
	    if (num_outstanding > 0)
		num_outstanding--;

	    cum_ack = pkt->seq_no;

	    
	    /*
	     * num_out must be decremented for (a)lost packets, (b)lost acks.
	     * and (c) lost acks of retransmitted packets. 
	     * (a) Lost packets are detected in the fast retx. code. 
 	     * Lost acks are detected by noticing that the the cum_ack 
	     * went  beyond last seen cum_ack+offset=ack_adjust. 
 	     * This  condition * is true if (but not only if) an ack was 
	     * lost. To see this, note
	     * that everything up to the largest cum_ack+offset has either
	     * been retransmitted, or correctly received. If cum_ack moved
	     * beyond it, the only reason can be a lost ack. Notes 8:135
	     */

	    if (cum_ack > ack_adjust)
		for (i = ack_adjust + 1; i < cum_ack; i++)
		    if (num_outstanding > 0)
			num_outstanding--;

	    /* now adjust num_out for lost acks of retransmissions */

	    /* we got an ack for a packet that was retransmitted */
	    if ((cum_ack + pkt->last_recvd_offset) <= ack_adjust)
		fast_retx_count--;

	    if ((cum_ack + pkt->last_recvd_offset) > ack_adjust) {
		/*
		 * we decrement num_outstanding to account for lost fast
		 * retransmissions or their acks
		 */
		if ((fast_retx_count > 0) and(num_outstanding > fast_retx_count)) {
		    num_outstanding -= fast_retx_count;
		    fast_retx_count = 0;
		}
	    }
	    if ((cum_ack + pkt->last_recvd_offset) > ack_adjust)
		ack_adjust = cum_ack + pkt->last_recvd_offset;

	    if (PP_PRINT)
		make_plot("num_out", num_outstanding);

	    /* once in B_COUNT  RTTs, we will increase B */

	    if (pkt->id >= rtt_seq) {
		rtt_count++;
		rtt_seq = transmission_id;
	    }

	    /*
	     * 1 RTT after a change in cum_ack , check to see if we have
	     * made progress. If not, retx the last ack, since it might
	     * have been lost again. Just to be sure, retx same pkt twice.
	     */

	    if (rtt_count is 2) {
		if (cum_ack is last_ack) {
		    make_pkt(retx_pkt);
		    retx_pkt->seq_no = last_ack + 1;
		    retx_pkt->resent = 1;
		    num_retx[node][retx_pkt->seq_no % MWS]++;
		    enq_high(node, retx_pkt);
		    dup_ack_retx++;

		    make_pkt(retx_pkt);
		    retx_pkt->seq_no = last_ack + 1;
		    retx_pkt->resent = 1;
		    num_retx[node][retx_pkt->seq_no % MWS]++;
		    enq_high(node, retx_pkt);
		    dup_ack_retx++;
		}
		/* we'll try again in one more RTT */
		rtt_seq = transmission_id;
		rtt_count = 1;
	    }

	    /* once in B_COUNT RTTS adjust B upwards */
	    if (rtt_count is B_COUNT) {
		if (PP_PRINT)
		    make_flt_plot("B", B);
		B += B_ADD_INC_FACTOR;
		if (PP_PRINT)
		    make_flt_plot("B", B);
	    }

	    /* since this is a cumulative ack */
	    for (i = last_ack + 1; i <= cum_ack; i++)
		recvd_ok[node][i % MWS] = 1;

	    /* for the pkt just acked */
	    recvd_ok[node][(cum_ack + pkt->last_recvd_offset) % MWS] = 1;

	    /* duplicate ack case */
	    if (pkt->last_recvd_offset > 0) {
		total_dup_acks++;

		/* scan space, retransmitting lost packets */
		for (i = 1; i < pkt->last_recvd_offset; i++) {
		    if (((num_retx[node][(cum_ack + i) % MWS]) is 0)
			and
			(not(recvd_ok[node][(cum_ack + i) % MWS]))) {
			if (BIG_CTH_DEBUG)
			    printf("%f : node %d: dup_ack seq_no %d enqueued\n",
				   make_float(now), node, (last_ack + i));
			make_pkt(retx_pkt);
			retx_pkt->seq_no = cum_ack + i;
			retx_pkt->resent = 1;
			num_retx[node][retx_pkt->seq_no % MWS]++;
			if (PP_PRINT)
			    make_plot("num_out", num_outstanding);
			if (num_outstanding > 0)
			    num_outstanding--;
			if (PP_PRINT)
			    make_plot("num_out", num_outstanding);
			enq_high(node, retx_pkt);
			dup_ack_retx++;
		    }
		}

		/* decrease B only once per loss episode */
		if (total_dup_acks is 1) {
		    if (PP_PRINT)
			make_flt_plot("B", B);
		    B = (B * B_DEC_FACTOR > B_MIN) ? B * B_DEC_FACTOR : B_MIN;
		    if (PP_PRINT)
			make_flt_plot("B", B);
		}
	    }

	    /* we made progress */
	    if (cum_ack > last_ack) {

		/* reset num_retx count */
		for (i = last_ack; i <= pkt->seq_no; i++)
		    num_retx[node][i % MWS] = 0;

		last_ack = cum_ack;
		total_dup_acks = 0;

		/* reset rtt_count */
		rtt_seq = transmission_id;
		rtt_count = 1;
	    }
	    /* compute round trip time */

	    diff = time_minus(now, pkt->gen_time);
	    tao = make_float(diff);
	    make_entry(tao, &rt_time[node]);

	    switch (pkt->decbit) {
	    case 0:	     /* first in burst (pair) */
		if (start_up)
		    reclean = tao;
		if (BIG_CTH_DEBUG)
		    printf("reclean %f\n", reclean);
		time_of_last_ack = now;
		first_of_pair = pkt->id;
		free(pkt);
		break;

	    case 1:	     /* second in burst */
		if ((pkt->id is first_of_pair + 1)) {
		    first_of_pair = -2;
		    /* just to be safe */

		    diff = time_minus(now, time_of_last_ack);
		    if (PP_PRINT)
			make_flt_plot("inter_ack", inter_ack);
		    inter_ack = make_float(diff);
		    if (PP_PRINT)
			make_flt_plot("inter_ack", inter_ack);

		    if (!start_up) {
			D(make_flt_plot("alpha", alpha);)
			alpha = compute_alpha(se, inter_ack);
			D(make_flt_plot("alpha", alpha);)

			se = alpha * se + (1 - alpha) * inter_ack;
			if (PP_PRINT)
			    make_flt_plot("nbhat", nbhat);
			nbhat = num_outstanding - (reclean / se);
			nbhat = (nbhat > 0) ? nbhat : 0.0;
			nbhat = (nbhat > ftp_window) ? ftp_window : nbhat;
			if (PP_PRINT)
			    make_flt_plot("nbhat", nbhat);

			/*
			 * if we are pushing queue up, can be more
			 * conservative than if we are pushing queue down
			 */

			if (nbhat <= B)
			    re = ATTACK_UP * (reclean + nbhat * se);
			else
			    re = ATTACK_DOWN * (reclean + nbhat * se);


			/* control law from thesis page 67 */

			send_rate = (B - nbhat) / re + 1 / se;

			/*
			 * special case: if nbhat is very small (<2), then
			 * it is likely that the probe values are wrong.
			 * In this case, it is better to be conservative
			 */

			if (nbhat <= 2.0 and(send_rate > mean_send_rate)) {
			    send_rate = (mean_send_rate +
			      (send_rate - mean_send_rate) * INC_FACTOR);
			}
			mean_send_rate = mean_send_rate * MS_ALPHA +
			    (send_rate) * (1 - MS_ALPHA);

			/*
			 * special case: if we have overflowed bottleneck
			 * by a large amount, and so send rate is too low,
			 * set timer to the time that the queue would be
			 * drained
			 */

			if ((nbhat > 3 * B) and(send_rate < 2.0 / ((nbhat - B) * se)))
			    send_rate = 2.0 / ((nbhat - B) * se);

			/* time taken to drain queue to B */

			if (PP_PRINT) {
			      make_flt_plot("mean_send_rate",
			      mean_send_rate);
			}
			D(printf("node %d: nbhat %f , num_out %d, re %f, inter_ack %f, se %f, send_rate %f alpha %f\n", node, nbhat, num_outstanding, re, inter_ack, se, send_rate, alpha);)
			timeout = TIMEOUT_MULTIPLIER * re;
			free(pkt);
		    } else { /* got first pair of acks at time RTT */
			re = tao;
			se = inter_ack;
			start_up = 0;
			send_rate = 1 / se;

			send_rate = (mean_send_rate +
			      (send_rate - mean_send_rate) * INC_FACTOR);
			mean_send_rate = mean_send_rate * MS_ALPHA +
			    (send_rate) * (1 - MS_ALPHA);

			D(printf("node %d: startup inter_ack %f, se %f, send_rate %f \n", node, inter_ack, se, send_rate);)

#ifndef NO_FLOW_CONTROL
			/* convert to first tick; compute tick size */
			pkt->type = TIMER;
			set_timer((float) (2.0 / send_rate), pkt);
			if(tick is 0)
			    tick = 2;   /* we need this since pkt->bit is
                                         * set to 1-tick, which blows up
                                         * if tick is set to 2 twice
                                         * before it hits 0 */

#endif
			goto test;
		    }	     /* start up */
		} else {
		    first_of_pair = -2;
		    time_of_last_ack = time_zero;
		    free(pkt);
		    goto test;
		}
		break;
	    default:
		free(pkt);
		break;
	    }
	    goto test;
	case INT:
	    line_busy = 0;
	    free(pkt);
	    goto test;
#ifndef NO_FLOW_CONTROL
	case TIMER:
	    if (BIG_CTH_DEBUG)
		printf("setting tick of %d\n", (int) (2 * MILLION / send_rate));
	    if (last_sent < num_pkts[node]) {
		set_timer((float) (2.0 / send_rate), pkt);
	    }
	    if (PP_PRINT) {
		make_flt_plot("send_rate", old_send_rate);
		make_flt_plot("send_rate", send_rate);
		old_send_rate = send_rate;
	    }
	    if (tick is 0)
		tick = 2;    /* we need this since pkt->bit is set to
			      * 1-tick, which blows up if tick is set to 2
			      * twice before it hits 0 */
	    goto test;

#endif
	case TIMEOUT:
	    /*
	     * put all unacked packets in the retx. queue. If an ack
	     * arrives, it will clean out the extra pkts
	     */

	    if (pkt->id is(transmission_id - 1))
		/* simulate single timer */
	    {
		if (PP_PRINT) {
		    make_plot("timeout", 0);
		    make_flt_plot("timeout", timeout * 500.0);
		    make_plot("timeout", 0);
		}
		free(pkt);
		D(printf("%f : node %d: timeout on seq_no %d\n", make_float(now), node, pkt->seq_no);)

		if (PP_PRINT)
		    make_flt_plot("B", B);
		B = B_INITIAL;
		if (PP_PRINT)
		    make_flt_plot("B", B);

		for (i = last_ack + 1; i <= last_sent; i++) {
		    if (!recvd_ok[node][i % MWS]) {
			/* dont change value of timeout - no backoff */
			make_pkt(retx_pkt);
			retx_pkt->seq_no = i;
			retx_pkt->resent = 1;
			enq_high(node, retx_pkt);
			num_timeouts++;
		    }
		}

		num = num_in_q(node);

		if (start_up and num is 1) {	/* make a copy so that
						 * there is a pair */
		    make_pkt(retx_pkt);
		    retx_pkt->seq_no = last_ack + 1;
		    retx_pkt->resent = 1;
		    enq_high(node, retx_pkt);
		    num_timeouts++;
		}
		if (start_up)
		    tick = 2;

		/* sweep up singleton, if any. Can't be in middle of pair */

		if (num is 1) {
		    pkt = deq(node);
		    pkt->decbit = 2;
		    pkt->gen_time = runtime();
		    pkt->id = transmission_id++;
		    if (pkt->resent) {
			num_retransmissions[node]++;
			fast_retx_count++;
		    } else
			num_retx[node][pkt->seq_no % MAX_WINDOW_SIZE] = 0;

		    recvd_ok[node][pkt->seq_no % MWS] = 0;
		    if (pkt->seq_no > last_sent)
			last_sent = pkt->seq_no;
		    if (num_in_q(node) is 0)
			tick = 0;
		    safe_send(pkt, timeout);
		    if (PP_PRINT)
			make_plot("num_out", num_outstanding);
		    num_outstanding++;
		    if (PP_PRINT)
			make_plot("num_out", num_outstanding);
		    line_busy = 1;
		}
	    } else
		free(pkt);

	    goto test;

	case SINGLETON:     /* clean out singleton. Need this in case the
			      * source sent only 1 pkt */
	    free(pkt);
	    if (tick is 0 or tick is 2) {	/* not in middle of pair */
		num = num_in_q(node);
		if (num is 1) {
		    pkt = deq(node);
		    pkt->decbit = 2;
		    pkt->gen_time = runtime();
		    pkt->id = transmission_id++;
		    if (pkt->resent) {
			num_retransmissions[node]++;
			fast_retx_count++;
		    } else
			num_retx[node][pkt->seq_no % MAX_WINDOW_SIZE] = 0;

		    recvd_ok[node][pkt->seq_no % MWS] = 0;
		    if (pkt->seq_no > last_sent)
			last_sent = pkt->seq_no;
		    safe_send(pkt, timeout);
		    if (PP_PRINT)
			make_plot("num_out", num_outstanding);
		    num_outstanding++;
		    if (PP_PRINT)
			make_plot("num_out", num_outstanding);
		    line_busy = 1;
		}
	    }
	    goto test;
#ifdef PP_TRANS
	case DATA:
	    app_node = pkt->source;
	    pkt->dest = sink;
	    pkt->resent = 0;
	    pkt->seq_no = seq_no++;
	    pkt->source = node;
	    enq(node, pkt);
	    make_pkt(sing_pkt);
	    sing_pkt->type = SINGLETON;
	    set_timer((float) (SINGLETON_TIMEOUT * scale_factor), sing_pkt);
	    goto test;

	case NO_MORE_DATA:
	    no_more_data = 1;
	    free(pkt);
	    goto test;

#endif
	default:
	    pr_error("Node %d: pp source recvd. an unknown pkt ", node);
	}

test:
	num = num_in_q(node);
	if (PP_PRINT)
	    make_plot("num_q", num);
#ifdef PP_TRANS
	/*
	 * if the tx. queue is empty and everything acked, ask for more
	 * and wait
	 */
	if (app_node isnt 0 and(not no_more_data) and num is 0 and seq_no <= last_ack + 1) {
	    make_pkt(pkt);
	    pkt->type = TX_Q_EMPTY;
	    sendm(app_node, 0, pkt);
	    goto recv;
	}
#else
	if (num < tick) {
	    for (i = 0; i < tick - num; i++) {
		make_pkt(pkt);
		pkt->dest = sink;
		pkt->resent = 0;
		pkt->seq_no = seq_no++;
		enq(node, pkt);
	    }
	}
	if (num < tick)
	    num = tick;
#endif

	D(printf("%f: test: tick %d, busy %d, out %d, touts %d timeout %f dup_acks %d\n", make_float(now), tick, line_busy, num_outstanding, num_timeouts, timeout, dup_ack_retx);)

	if (((tick is 2 and num >= 2) or(tick is 1 and num >= 1))	/* have a pair */
	    and(not line_busy)
#ifndef NO_FLOW_CONTROL
	    and((num_outstanding - 1 < ftp_window - tick)
		or num_timeouts or(dup_ack_retx >= 2))
	    and((last_sent < last_ack + ftp_window - tick)
		or num_timeouts or(dup_ack_retx >= 2))
#endif
	    and(last_sent < num_pkts[node] - 1)
	    ) {
	    pkt = deq(node);
	    if (pkt is NULL)
		goto recv;

	    tick--;
	    if (tick is 0) {
		if (num_timeouts >= 2)
		    num_timeouts -= 2;
		else
		    num_timeouts = 0;

		if (dup_ack_retx >= 2)
		    dup_ack_retx -= 2;
		else
		    dup_ack_retx = 0;
	    }
	    /* set up packet pair ID: */

	    pkt->decbit = 1 - tick;
	    pkt->gen_time = runtime();
	    pkt->id = transmission_id++;

	    if (pkt->resent) {
		num_retransmissions[node]++;
		fast_retx_count++;
	    } else
		num_retx[node][pkt->seq_no % MAX_WINDOW_SIZE] = 0;

	    recvd_ok[node][pkt->seq_no % MWS] = 0;

	    if (pkt->seq_no > last_sent)
		last_sent = pkt->seq_no;

	    if (num_in_q(node) is 0)
		tick = 0;    /* so that delays in getting next of pair
			      * will not affect pair */
	    safe_send(pkt, timeout);
	    if (PP_PRINT)
		make_plot("num_out", num_outstanding);
	    num_outstanding++;
	    if (PP_PRINT)
		make_plot("num_out", num_outstanding);
	    line_busy = 1;
	}
	goto recv;
    }
}
