/*
 * ARGS USED: average rate 
 * NOT USED : peak_rate, on_time, off_time, interval
 *
 * poisson sends data at an average rate chosen by the average_rate parameter
 * It is not really poisson, since it cannot send faster than the outgoing
 * line speed.
 */

#include "../kernel/real.h"

poisson()
{
    PKT_PTR         pkt, tick_pkt = (PKT_PTR)0;
    int             num, node, seq_no = 0, pkts_sent = 0;
    int             start_up = 1, line_busy = 0, tick = 1;
    ident           destn, sender, sink;
    long            key;
    timev	    now;
    float	    delay;

    node = get_node_id();
    source_node_type[node] = POISSON_SOURCE;
    sink = assigned_sink[node];
    abs_advance(node_start_time[node]);

    printf("Poisson source: %d ", get_node_id());
    printf("--> %d, start (%d, %d) average rate %.3f\n", 
	   sink, node_start_time[node].tv_sec, node_start_time[node].tv_usec,
	   ave_bandwidth[node]);

    goto test;

    for (ever)
    {
recv:
	sender = recvm(&destn, &key, &pkt);
	switch (pkt->type)
	{
	case ACK:
	    free(pkt);
	    goto recv;
	case INT:
	    line_busy = 0;
	    free(pkt);
	    goto test;
	case TIMER:
	    tick = 1;
            tick_pkt = pkt;
	    goto test;
	default:
	    free(pkt);
	    printf("pkt->type %d, pkt->so %d, pkt->dest  %d\n",
			pkt->type, pkt->source, pkt->dest);
	    pr_error("source received a pkt of unknown type", node);
	}
    }

test:

    if (tick and (not line_busy) and pkts_sent < num_pkts[node])
    {
        tick = 0;
	line_busy = 1;
	make_pkt(pkt);
	pkt->seq_no = seq_no ++;
	pkt->gen_time = runtime();
	pkt->gs = 0;
	pkts_sent ++;
	send_pkt(pkt);
	
	/* schedule next tick */

	/* you can have any input distribution you want - gaussian, gamma,
	 * etc.  simply by changing the function call here 
	 * 
	 * see sim/etc/distrib.c
	 */


	delay = expntl((ftp_size * 8.0)/ave_bandwidth[node]);

        if(tick_pkt is (PKT_PTR)0)      /* start up */
        {
            make_pkt(tick_pkt);
            tick_pkt -> type = TIMER;
        }

	set_timer(delay, tick_pkt);

    }
    goto recv;
}
