/*
 * Playout receives data from coders. It sends an ack with the sequence
 * number set to the last in-sequence packet seen so far
 * If a frame arrives too late, playout will print an error message
 * 
 * There is a hidden assumption that the output line is never busy and that
 * only one stream is received by each playout node
 */

extern int      SI_DEBUG;

#include "../kernel/real.h"

#define  PLAYBACK_PT 0.1 		/* sec */

playout()
{
    PKT_PTR         pkt, new_pkt, tick_pkt;
    int             i, j, source, num, conv_id;
    ident           destn, node, sender;
    long            key;
    int             last_in_seq[MAX_CONVERSATIONS];
    /* last in-sequence seq_no from this conv */
    int             seen[MAX_CONVERSATIONS][MAX_WINDOW_SIZE];
    /* this seq no has been seen */
    timev           now, diff;
    char            fname[20], start_up;
    int             current_frame = 1;
    float	    time_in_node, first_arr_time;
    float	    drain_time;	


    node = get_node_id();
    abs_advance(node_start_time[node]);
    source_node_type[node] = SINK;
    printf("Playout node : %d\n", node);

    for (i = 0; i < MAX_CONVERSATIONS; i++)
    {
	last_in_seq[i] = -1;
	for (j = 0; j < MAX_WINDOW_SIZE; j++)
	    seen[i][j] = 0;
    }

    start_up = 1;

    for (ever)
    {
recv:
	sender = recvm(&destn, &key, &pkt);
	now = runtime();

	switch (pkt->type)
	{
	case DATA:
	    if(start_up)
	    {
		first_arr_time = make_float(now);
		start_up = 0;
	    }

	    source = pkt->source;
	    conv_id = hash(node, source, pkt->dest);

	    if (pkt->trace)
	    {
		diff = time_minus(now, pkt->gen_time);
		sprintf(fname, "e2e.%d.", source);
		make_flt_plot(fname, make_float(diff));
	    }
	    if (pkt->gs)
	    {
		free(pkt);   /* no ack for gs source */
		goto recv;
	    } else
	    {
		if (pkt->seq_no > last_in_seq[conv_id])
		    /*
		     * setting the sequence number - should be the last in
		     * sequence packet seen
		     */
		{
		    int             ack, window;

		    window = MAX_WINDOW_SIZE;
		    seen[conv_id][pkt->seq_no % window] = 1;
		    ack = last_in_seq[conv_id];
		    while (seen[conv_id][(ack + 1) % window])
		    {
			ack++;
			seen[conv_id][ack % window] = 0;
		    }
		    last_in_seq[conv_id] = ack;
		    if (SI_DEBUG)
			printf("(%d,%d):Sink sent an ack seq # %d\n",
			       now.tv_sec, now.tv_usec, ack);
		}

		/* given the current time, we know which frame is being
		   served at this time */

		time_in_node = make_float(now) - first_arr_time;
		drain_time = time_in_node - PLAYBACK_PT * scale_factor;

		if(drain_time < 0)
		    current_frame = 0;
		else
		    current_frame = (int) (drain_time * 30.0 / scale_factor) + 1;

		if(pkt->frameno < current_frame) 
		{
		    /*printf("current frame is %d\n", current_frame);*/
		    printf("%d:S%d drop C%d frame %d mb_low %d mb_high %d\n",
		           now.tv_sec, node, pkt->source, pkt->frameno,
		    pkt->low_mb, pkt->high_mb);
		}

		/* send an ack by changing the packet's params */

		pkt->seq_no = last_in_seq[conv_id];
		pkt->type = ACK;
		pkt->size = ack_size;
		pkt->source = node;
		pkt->dest = source;	/* a global id */
		pkt->trace = 0;
		if (!sendm(route[node][pkt->dest], 0, (char *) pkt))
			pr_error("sendm failed in sink");
	    }
	    break;

	case SETUP:
	    {
		pkt->dest = pkt->source;
		pkt->source = node;
		pkt->type = SETUP_ACK;
		pkt->size = ack_size;
		pkt->gs = 0; /* ACKS are not set up, so BE */
		sendm(route[node][pkt->dest], 0, (char *) pkt);

	    } break;
	default:
	    free(pkt);
	}
    }
}
