/*
 * ARGS USED: average rate, on_time, off_time
 * NOT USED : peak rate, interval
 *
 *  onoff_closed_gbn  sends data at an nominal rate of averate_rate over its entire operation. 
 *  data is sent for exponential (on_time) seconds, then the source waits till
 *  the packets are sent and acked, then sleeps for  exponential (off_time) 
 *  seconds.  This makes the queueing system closed.
 *  Retransmission is go_back_n.
 */


#include "../kernel/real.h"

#define ON 1
#define OFF 0
#define WAIT 2

#define ALPHA 0.625
#define ON_OFF_TIMER 11 

#define D(x) 

/*
 * Control parameters 
 */

void
onoff_closed_gbn()
{
    ident   destn, sender, sink;
    PKT_PTR pkt, p;
    PKT_PTR tick_pkt, timer_pkt;
    int     line_busy = 0, tick = 1, last_sent = -1, seq_no = 0;
    int     last_ack = -1, pkts_sent = 0, pkt_count, node, i, num;
    int	    transmission_id = 0, num_retx = 0;
    long    key; 
    timev   now, diff;
    float   timeout = 0.5, tao, rtt_est = 0.0, delay, flt_pkt_count, t;
    int     state = ON, tx_q_empty = 0;;

    node = get_node_id ();
    sink = assigned_sink[node];
    source_node_type[node] = BACKGROUND_SOURCE;
    abs_advance (node_start_time[node]);

    printf ("On off closed GBN source %d ", get_node_id ());
    printf ("--> %d, start %f, on %f, off %f, average %f\n",
        sink, make_float(node_start_time[node]), 
        on_time[node], off_time[node], ave_bandwidth[node]);
   
    /* delay is the average inter_pkt delay given the on, off times 
     * and the nominal on_off source rate  (in average_rate) */

    delay = (float) (8.0 * (float) ftp_size/(ave_bandwidth[node] * (1.0 + ((float)off_time[node]/(float)on_time[node]))));

    make_pkt(tick_pkt);
    tick_pkt->type = TIMER;
    /* set_timer(delay, tick_pkt); */
D(printf("setting rate-control timer for %f\n", delay);)

    make_pkt(timer_pkt);
    timer_pkt->type = ON_OFF_TIMER;
    set_timer(t = expntl(on_time[node]), timer_pkt);
now = runtime();
D(printf("now %f initial off_time is %f\n", make_float(now), t);)
    goto test;

    for (ever)
    {

recv: 
	sender = recvm (&destn, &key, &pkt);
	now = runtime ();
D(printf("%6.4f: got ", make_float(now));)
	switch (pkt -> type)
	{
	    case ACK: 
D(printf("ack of seq %d\n", pkt->seq_no);)
		make_plot("ack", pkt->seq_no);
		last_ack = pkt->seq_no;
		tao = make_float(now) - make_float(pkt->gen_time);
		rtt_est = ALPHA * rtt_est + (1-ALPHA) * tao;
		timeout = 2*rtt_est;

                /* if something in retx. queue can be removed, do so */
                num = num_in_q(node);
                for(i = 0; i < num; i++) {
                    p = deq(node);
                    if(p->seq_no > last_ack) {
                        enq(node, p);
		    } else {
		 	if(p->resent)
			    num_retx --;
                        free(p);
		    }
                }

		free (pkt);

		if(state is WAIT) {
	    	    make_pkt(pkt);
		    pkt->type = TX_Q_EMPTY;
		    set_timer(0.0, pkt);
D(printf("queue empty: send tx_q_qmpty\n");)
		    goto recv;
	        }

		goto test;

	    case INT: 
D(printf("int\n");)
		line_busy = 0;
		free (pkt);
		goto test;

	    case TIMEOUT:
D(printf("timeout\n");)
D(printf("pkt->id is %d, transmission_id %d\n", pkt->id, transmission_id);)
		if(pkt->id is transmission_id - 1) {
		    free(pkt);
		    for(i=last_ack + 1; i <= last_sent; i++) {
			make_pkt(pkt);
			pkt->seq_no = i;
			pkt->resent = 1;
			num_retx ++;
			enq_high(node, pkt);
		    }
		    timeout = 2*timeout;
		} else
		    free(pkt);
		
		goto test;

	    case TIMER:
D(printf("timer\n");)
		tick = 1;
		tick_pkt = pkt;
		goto test;

	    case TX_Q_EMPTY:
D(printf("tx_q_empty\n");)
		tx_q_empty = 1;
		if(state is WAIT) {
                    state = OFF;
                    set_timer(expntl(off_time[node]), timer_pkt);
D(printf("set timer for off state\n");)
		}
		free(pkt);
                goto test;
 
	    case ON_OFF_TIMER:
D(printf("on_off_timer\n");)
		timer_pkt = pkt;
		if(state is ON and tx_q_empty){
		    float e;
		    state = OFF;
		    set_timer(e = expntl(off_time[node]), timer_pkt);
D(printf("set timer for OFF state, now in ON\n");)

                    /* make_flt_plot ("off", e); */
		    goto test;
		} else if(state is ON and not tx_q_empty) {
D(printf("setting state to WAIT\n");)
		    state = WAIT;
		    goto test;

		} else if(state is OFF){
		    state = ON ;
		    tx_q_empty = 0;
		    set_timer(expntl(on_time[node]), timer_pkt);
D(printf("set timer for ON state, now in OFF\n");)
		    goto test;
		} 
		goto test;		
	    default: 
		free (pkt);
		pr_error ("background src. recvd. an unknown pkt ");
	}
    }
test: 
    num = num_in_q(node);
D(printf("test: num is %d\n", num);)
    if(num is 0 and state is ON) {
        make_pkt(pkt);
        pkt->seq_no = seq_no ++;
   	enq(node, pkt);
D(printf("enqueued packet seq # %d\n", seq_no - 1);)
    } 
    num = num_in_q(node);
    if(num is 0)
    	goto recv;

D(printf("line_busy %d tick %d last_sent %d last_ack %d pkts_sent %d\n",
line_busy, tick, last_sent,  last_ack, pkts_sent ); )

    if ((!line_busy) and tick and 
       (((last_sent - last_ack) < ftp_window) or num_retx)
    and  pkts_sent < num_pkts[node]) {
D(printf("test succeeded\n");)

	tick = 0;
	line_busy = 1;

 	pkt = deq(node);
	pkt->gen_time = runtime ();
	pkt->id = transmission_id ++;

	/* update last_sent */
        if (pkt->seq_no > last_sent)
            last_sent = pkt->seq_no;

 	if(pkt->resent){
            num_retransmissions[node]++;
	    num_retx --;
	} else
	    pkts_sent++;

	safe_send(pkt, timeout);
now = runtime();
D(printf("%f : sent a packet seq %d\n", make_float(now), pkt->seq_no);)
	set_timer(delay, tick_pkt);

    }
    goto recv;
}
