/*
 * ARGS USED: average rate, on_time, off_time
 * NOT USED : peak rate, interval
 *
 *  onoff_closed  sends data at an nominal rate of averate_rate over its entire operation. 
 *  data is sent for exponential (on_time) seconds, then the source waits till
 *  the tx layer has informed it that the tx queue is empty, then nothing is sent for 
 *  exponential (off_time) seconds.  This makes the queueing system closed.
 */


#include "../kernel/real.h"

#define ON 1
#define OFF 0
#define WAIT 2

#define ON_OFF_TIMER 11 

/*
 * Control parameters 
 */

void
onoff_closed()
{
    ident   destn, sender, sink;
    PKT_PTR pkt;
    PKT_PTR tick_pkt, timer_pkt;
    int     line_busy = 0, tick = 1, last_sent = -1, seq_no = 0;
    int     pkts_sent = 0, pkt_count, node;
    long    key; 
    timev   now, diff;
    float   delay, flt_pkt_count;
    int     state = ON, tx_q_empty = 0;;

    node = get_node_id ();
    sink = assigned_sink[node];
    source_node_type[node] = BACKGROUND_SOURCE;
    abs_advance (node_start_time[node]);

    printf ("On off closed source %d ", get_node_id ());
    printf ("--> %d, start %f, on %f, off %f, average %f\n",
        sink, make_float(node_start_time[node]), 
        on_time[node], off_time[node], ave_bandwidth[node]);
   
    /* delay is the average inter_pkt delay given the on, off times 
     * and the nominal on_off source rate  (in average_rate) */

    delay = (float) (8.0 * (float) ftp_size/(ave_bandwidth[node] * (1.0 + ((float)off_time[node]/(float)on_time[node]))));
    make_pkt(tick_pkt);
    tick_pkt->type = TIMER;
    set_timer(delay, tick_pkt);

    make_pkt(timer_pkt);
    timer_pkt->type = ON_OFF_TIMER;
    set_timer(expntl(on_time[node]), timer_pkt);
    goto test;
    for (ever)
    {

recv: 
	sender = recvm (&destn, &key, &pkt);
	now = runtime ();
	switch (pkt -> type)
	{
	    case ACK: 
		free (pkt);
		goto recv;
	    case INT: 
		line_busy = 0;
		free (pkt);
		goto test;

	    case TIMER: 
		tick = 1;
		tick_pkt = pkt;
		goto test;

	    case TX_Q_EMPTY:
		tx_q_empty = 1;
		if(state is WAIT) {
		    float e;
                    state = OFF;
                    set_timer(e = expntl(off_time[node]), timer_pkt);
		    /*  make_flt_plot ("off", e);  */
		}
		free(pkt);
                goto test;
 
	    case ON_OFF_TIMER:
		timer_pkt = pkt;
		if(state is ON and tx_q_empty){
		    float e;
		    state = OFF;
		    set_timer(e = expntl(off_time[node]), timer_pkt);
                    /* make_flt_plot ("off", e); */
		    goto test;
		} else if(state is ON and not tx_q_empty) {
		    state = WAIT;
		    goto test;

		} else if(state is OFF){
		    state = ON ;
		    tx_q_empty = 0;
		    set_timer(expntl(on_time[node]), timer_pkt);
		    goto test;
		} 
		goto test;		
	    default: 
		free (pkt);
		pr_error ("background src. recvd. an unknown pkt ");
	}
    }
test: 
    if ((!line_busy) and tick and (state is ON) and pkts_sent < num_pkts[node])
    {
	tick = 0;
	line_busy = 1;

	make_pkt(pkt);
	pkt->seq_no = seq_no ++;
	pkt->gen_time = runtime ();
	send_pkt(pkt);
	pkts_sent++;
	set_timer(delay, tick_pkt);

        if(pkts_sent is num_pkts[node]) {
    	    make_pkt(pkt);
	    pkt->type = NO_MORE_DATA;
	    pkt->seq_no = seq_no;
	    send_pkt(pkt);
        }
    }
    goto recv;
}
