/*
 * ARGS USED: average rate, on_time, off_time
 * NOT USED : peak rate, interval
 *
 *  onoff sends data at an nominal rate of averate_rate over its entire operation. 
 *  data is sent for exponential (on_time) seconds, then nothing is sent for 
 *  exponential (off_time) seconds. 
 */


#include "../kernel/real.h"

#define ON 1
#define OFF 0
#define ON_OFF_TIMER 9

/*
 * Control parameters 
 */

void
onoff()
{
    ident   destn, sender, sink;
    PKT_PTR pkt;
    PKT_PTR tick_pkt;
    int     line_busy = 0, tick = 1, last_sent = -1, seq_no = 0;
    int     pkts_sent = 0, pkt_count, node;
    long    key; 
    timev   now;
    float   delay, flt_pkt_count;
    int     on_off = ON;

    node = get_node_id ();
    sink = assigned_sink[node];
    source_node_type[node] = BACKGROUND_SOURCE;
    abs_advance (node_start_time[node]);

    printf ("On off source %d ", get_node_id ());
    printf ("--> %d, start (%d, %d), on %d, off %d, average %f\n",
        sink, node_start_time[node].tv_sec,
        node_start_time[node].tv_usec,
        on_time[node], off_time[node], ave_bandwidth[node]);
   
    /* delay is the average inter_pkt delay given the on, off times 
     * and the nominal on_off source rate  (in average_rate) */

    delay = (float) (8.0 * (float) ftp_size/(ave_bandwidth[node] * (1.0 + ((float)off_time[node]/(float)on_time[node]))));
    make_pkt(tick_pkt);
    tick_pkt->type = TIMER;
    set_timer(delay, tick_pkt);

    make_pkt(pkt);
    pkt->type = ON_OFF_TIMER;
    set_timer(expntl(on_time[node]), pkt);
    goto test;
    for (ever)
    {

recv: 
	sender = recvm (&destn, &key, &pkt);
	now = runtime ();
	switch (pkt -> type)
	{
	    case ACK: 
		free (pkt);
		goto recv;
	    case INT: 
		line_busy = 0;
		free (pkt);
		goto test;
	    case TIMER: 
		tick = 1;
		tick_pkt = pkt;
		goto test;
	    case ON_OFF_TIMER:
		if(on_off is ON){
		    on_off = OFF;
		    set_timer(expntl(off_time[node]), pkt);
		    goto recv;
		} else {
		    on_off = ON ;
		    set_timer(expntl( on_time[node]), pkt);
		    goto test;
		} 
	    case TX_Q_EMPTY:
		free(pkt);
		goto recv;
	    default: 
		free (pkt);
		pr_error ("background src. recvd. an unknown pkt ");
	}
    }
test: 
    if ((!line_busy) and tick and on_off is ON and pkts_sent < num_pkts[node])
    {
	tick = 0;
	line_busy = 1;

	make_pkt(pkt);
	pkt->seq_no = seq_no ++;
	pkt->gen_time = runtime ();
	send_pkt(pkt);
	pkts_sent++;
	set_timer(delay, tick_pkt);

        if(pkts_sent is num_pkts[node]) {
    	    make_pkt(pkt);
	    pkt->type = NO_MORE_DATA;
	    pkt->seq_no = seq_no;
	    send_pkt(pkt);
        }
    }
    goto recv;
}
