extern int      CODER_DEBUG;
/*
 * NOT USED : average_rate, peak_rate, on_time, off_time, interval
 * 
 * mpeg simulates a MPEG video coder. it reads from a file that contains
 * records of the form <frame#, macroblock#, # of bits> and sends them 
 * out
 */

#define MACROBLOCKS 330

#include "../kernel/real.h"

int             current_frame;	/* current frame being processed */
mpeg()
{
    PKT_PTR         pkt, tick_pkt, cell;
    int             junk, i, num, node, seq_no = 0, pkts_sent = 0;
    int             start_up = 1, tick = 0, size;
    ident           destn, sender, sink;
    long            key;
    timev           now;
    FILE           *f;
    float           next_target_rate = 0.0, next_next_target_rate = 0.0;
    char            first_frame_out = 0;
    int		    macroblock[MACROBLOCKS], num_bits, num_cells=0;

    node = get_node_id();
    source_node_type[node] = CODER_SOURCE;
    sink = assigned_sink[node];
    printf("node %d reading from file %s\n", node, input_file[node]);
    f = fopen(input_file[node], "r");
    if (!f)
	pr_error("Coder node unable to open input file specified \n");
    abs_advance(node_start_time[node]);

    printf("MPEG source: %d \n", node);
    fflush(stdout);

    initiate_setup;


    for (ever)
    {
recv:
	sender = recvm(&destn, &key, &pkt);
	now = runtime();
	switch (pkt->type)
	{

	case SETUP_ACK:
	    if (pkt->ave_bandwidth is 0.0)	/* refused ! */
	    {
		printf("node %d refused, not enough bandwith \n", node);
		goto recv;
	    } else if (pkt->peak_bandwidth is 0.0)
	    {
		printf("node %d refused, not enough buffer \n", node);
		goto recv;
	    }
	    printf("node %d connection ok: starting \n", node);
            /* first tick */
    	    make_pkt(tick_pkt);
    	    tick_pkt->type = TIMER;
            set_timer(0.0, tick_pkt);
	    goto recv;

	case TIMER:
	    set_timer((float)(0.033333 * scale_factor), pkt);
	    for (i = 1; i <= MACROBLOCKS; i++)
	    {
		if (fscanf(f, "%d %d %d \n", &current_frame, &junk, &(macroblock[i])) is EOF)
		    while (1)
			sender = recvm(&destn, &key, &pkt);
	    }

	    num_bits = 0;
	    for (i = 1; i <= MACROBLOCKS; i++)
		num_bits += macroblock[i];

	    num_cells = (int) (num_bits / (8.0 * 48.0)) + 1;
            goto test;

	case INT:
	    free(pkt);
test:	   if (num_cells > 0) 
	    {
		make_pkt(cell);
		cell->seq_no = seq_no ++;
	 	cell->gen_time = now;
		cell->size = 53;
		cell->gs = 1;
                num_cells--;
		send_pkt(cell);
	    }
	    break;
	default:
	    free(pkt);
	    pr_error("Node %d: source received a pkt of unknown type", node);
	}
    }
}
