/*
 * ARGS USED:  none
 * NOT USED : peak rate, average rate, on_time, off_time, interval
 *
 * This simulates something like a 2 state markov modulated poisson process 
 *
 * Since the probability of changing state is evaluated only at the end
 * of the residence time in a state, states with longer mean intensities
 * will have a lower chance of being evaluated for a change of state,
 * so this is not exactly right. This source should be reasonable for
 * generating bursty traffic 
 */ 

#include "../kernel/real.h"

#define PROB_HIGH 0.2		/* P(low to high) */
#define HIGH_RATE 3.0 		/* packets/sec */
#define PROB_LOW  0.8		/* P(high to low) */
#define LOW_RATE  0.5		/* packets/sec */

/* states */
#define LOW 0
#define HIGH 1	

mmpp()
{
    PKT_PTR         pkt, tick_pkt = (PKT_PTR)0;
    int             num, node, seq_no;
    int             line_busy = 0, tick = 1, last_ack;
    ident           destn, sender, sink;
    long            key, tick_estimate = 5000;
    timev           now, diff;
    int             pkts_sent = 0;
    int 	    state = LOW;
    float	    delay;

    node = get_node_id ();
    sink = assigned_sink[node];
    abs_advance (node_start_time[node]);

    printf ("MMPP source: %d ", get_node_id ());
    printf("--> %d, start (%d, %d)\n",
           sink, node_start_time[node].tv_sec, node_start_time[node].tv_usec);

    source_node_type[node] = MMPP_SOURCE;
    goto test;

    for (ever)
    {
recv:
	sender = recvm (&destn, &key, &pkt);
	now = runtime ();
	switch (pkt->type)
	{
        case ACK:
            free(pkt);
            goto recv;
        case INT:
            line_busy = 0;
            free(pkt);
            goto test;
        case TIMER:
            tick = 1;
            tick_pkt = pkt;
            goto test;
        default:
            free(pkt);
            pr_error("Node %d: source received a pkt of unknown type",
node);
	}

test:
   if (!line_busy and tick and pkts_sent < num_pkts[node])
	{
        tick = 0;
        line_busy = 1;
        make_pkt(pkt);
	pkt->seq_no = seq_no ++;
        pkt->gen_time = runtime();
	pkts_sent ++;

	send_pkt(pkt);
	/* schedule next tick */

	switch(state)
	{
	case LOW:
		inter_pkt = 1.0/LOW_RATE;
		if(RANDOM < PROB_HIGH)
		    state = HIGH;
	 	break;
	case HIGH:
		inter_pkt = 1.0/HIGH_RATE;
		if(RANDOM < PROB_LOW)
		    state = LOW;
	  	break;
	}

        delay = (float) expntl (inter_pkt);

        if(tick_pkt is (PKT_PTR)0)      /* start up */
        {
            make_pkt(tick_pkt);
            tick_pkt -> type = TIMER;
        }

        set_timer(delay, tick_pkt);
        }
    }
}

